/*    */ package org.jboss.managed.plugins.factory;
/*    */ 
/*    */ import org.jboss.managed.spi.factory.RuntimeComponentNameTransformer;
/*    */ 
/*    */ public abstract class AbstractComponentNameTransformer<T>
/*    */   implements RuntimeComponentNameTransformer
/*    */ {
/*    */   private Class<T> type;
/*    */ 
/*    */   protected AbstractComponentNameTransformer(Class<T> type)
/*    */   {
/* 38 */     if (type == null)
/* 39 */       throw new IllegalArgumentException("Null type.");
/* 40 */     this.type = type;
/*    */   }
/*    */ 
/*    */   public Object transform(Object value)
/*    */   {
/* 45 */     if (value == null) {
/* 46 */       return null;
/*    */     }
/* 48 */     if (!this.type.isAssignableFrom(value.getClass())) {
/* 49 */       return new IllegalArgumentException("Value is not instance of " + this.type + ", value: " + value);
/*    */     }
/* 51 */     return doTransform(this.type.cast(value));
/*    */   }
/*    */ 
/*    */   protected abstract Object doTransform(T paramT);
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.managed.plugins.factory.AbstractComponentNameTransformer
 * JD-Core Version:    0.6.0
 */