/*     */ package org.jboss.managed.plugins.advice;
/*     */ 
/*     */ import java.util.Set;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
/*     */ import org.jboss.managed.api.Fields;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ import org.jboss.managed.api.ManagedProperty;
/*     */ 
/*     */ public class WrapperAdvice
/*     */ {
/*     */   public static ManagedObject wrapManagedObject(ManagedObject managedObject)
/*     */   {
/*  49 */     return (ManagedObject)createProxy(managedObject, ManagedObject.class);
/*     */   }
/*     */ 
/*     */   public static ManagedProperty wrapManagedProperty(ManagedProperty managedProperty)
/*     */   {
/*  60 */     return (ManagedProperty)createProxy(managedProperty, ManagedProperty.class);
/*     */   }
/*     */ 
/*     */   public static Fields wrapFields(Fields fields)
/*     */   {
/*  71 */     return (Fields)createProxy(fields, Fields.class);
/*     */   }
/*     */ 
/*     */   public ManagedObject wrapManagedObject(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  83 */     ManagedObject result = (ManagedObject)invocation.invokeNext();
/*  84 */     return wrapManagedObject(result);
/*     */   }
/*     */ 
/*     */   public ManagedProperty wrapManagedProperty(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  96 */     ManagedProperty result = (ManagedProperty)invocation.invokeNext();
/*  97 */     return wrapManagedProperty(result);
/*     */   }
/*     */ 
/*     */   public Set<ManagedProperty> wrapManagedPropertySet(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 110 */     Set result = (Set)invocation.invokeNext();
/* 111 */     return new WrapperSet(result, ManagedProperty.class);
/*     */   }
/*     */ 
/*     */   public Fields wrapFields(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 123 */     Fields result = (Fields)invocation.invokeNext();
/* 124 */     return wrapFields(result);
/*     */   }
/*     */ 
/*     */   static <T> T createProxy(T target, Class<T> interfaceClass)
/*     */   {
/* 137 */     return GeneratedAOPProxyFactory.createProxy(target, interfaceClass);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.managed.plugins.advice.WrapperAdvice
 * JD-Core Version:    0.6.0
 */