/*     */ package org.jboss.managed.plugins;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InvalidObjectException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.managed.api.Fields;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ import org.jboss.managed.api.ManagedProperty;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.values.MetaValue;
/*     */ import org.jboss.metatype.api.values.SimpleValue;
/*     */ 
/*     */ public class ManagedPropertyImpl
/*     */   implements ManagedProperty
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   private static final int VERSION1 = 1;
/*     */   private static final int STREAM_VERSION = 1;
/*     */   private ManagedObject managedObject;
/*     */   private ManagedObject targetManagedObject;
/*     */   private Fields fields;
/*     */   private transient String name;
/*     */ 
/*     */   public ManagedPropertyImpl(String name)
/*     */   {
/*  81 */     this(null, new DefaultFieldsImpl(name));
/*     */   }
/*     */ 
/*     */   public ManagedPropertyImpl(Fields fields)
/*     */   {
/*  94 */     this(null, fields);
/*     */   }
/*     */ 
/*     */   public ManagedPropertyImpl(ManagedObject managedObject, Fields fields)
/*     */   {
/* 107 */     init(managedObject, fields);
/*     */   }
/*     */ 
/*     */   public ManagedObject getManagedObject()
/*     */   {
/* 112 */     return this.managedObject;
/*     */   }
/*     */ 
/*     */   public void setManagedObject(ManagedObject managedObject)
/*     */   {
/* 122 */     this.managedObject = managedObject;
/*     */   }
/*     */ 
/*     */   public ManagedObject getTargetManagedObject()
/*     */   {
/* 127 */     return this.targetManagedObject;
/*     */   }
/*     */ 
/*     */   public void setTargetManagedObject(ManagedObject target)
/*     */   {
/* 132 */     this.targetManagedObject = target;
/*     */   }
/*     */ 
/*     */   public Fields getFields()
/*     */   {
/* 137 */     return this.fields;
/*     */   }
/*     */ 
/*     */   public <T> T getField(String fieldName, Class<T> expected)
/*     */   {
/* 144 */     if (fieldName == null)
/* 145 */       throw new IllegalArgumentException("Null field name");
/* 146 */     if (expected == null) {
/* 147 */       throw new IllegalArgumentException("Null expected type");
/*     */     }
/* 149 */     Serializable field = getFields().getField(fieldName);
/*     */ 
/* 151 */     if (field == null) {
/* 152 */       return null;
/*     */     }
/* 154 */     if (expected.isInstance(field)) {
/* 155 */       return expected.cast(field);
/*     */     }
/* 157 */     if ((field instanceof SimpleValue))
/*     */     {
/* 159 */       SimpleValue value = (SimpleValue)field;
/* 160 */       Object result = value.getValue();
/* 161 */       if (result == null)
/* 162 */         return null;
/* 163 */       return expected.cast(result);
/*     */     }
/*     */ 
/* 166 */     throw new IllegalStateException("Field " + fieldName + " with value " + field + " is not of the expected type: " + expected.getName());
/*     */   }
/*     */ 
/*     */   public void setField(String fieldName, Serializable value)
/*     */   {
/* 172 */     if (fieldName == null) {
/* 173 */       throw new IllegalArgumentException("Null field name");
/*     */     }
/* 175 */     getFields().setField(fieldName, value);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 180 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getMappedName()
/*     */   {
/* 185 */     return (String)getField("mappedName", String.class);
/*     */   }
/*     */ 
/*     */   public String getDescription()
/*     */   {
/* 190 */     return (String)getField("description", String.class);
/*     */   }
/*     */ 
/*     */   public void setDescription(String description)
/*     */   {
/* 200 */     setField("description", description);
/*     */   }
/*     */ 
/*     */   public Map<String, Annotation> getAnnotations()
/*     */   {
/* 210 */     Object set = getField("annotations", Object.class);
/* 211 */     return (Map)set;
/*     */   }
/*     */ 
/*     */   public void setAnnotations(Map<String, Annotation> annotations)
/*     */   {
/* 216 */     setField("annotations", (Serializable)annotations);
/*     */   }
/*     */ 
/*     */   public MetaType getMetaType()
/*     */   {
/* 221 */     return (MetaType)getField("metaType", MetaType.class);
/*     */   }
/*     */ 
/*     */   public void setMetaType(MetaType type)
/*     */   {
/* 231 */     setField("metaType", type);
/*     */   }
/*     */ 
/*     */   public Object getValue()
/*     */   {
/* 236 */     return getField("value", Object.class);
/*     */   }
/*     */ 
/*     */   public void setValue(Serializable value)
/*     */   {
/* 241 */     setField("value", value);
/*     */   }
/*     */ 
/*     */   public Set<MetaValue> getLegalValues()
/*     */   {
/* 247 */     return (Set)getField("legalValues", Set.class);
/*     */   }
/*     */ 
/*     */   public void setLegalValues(Set<MetaValue> values)
/*     */   {
/* 257 */     setField("legalValues", (Serializable)values);
/*     */   }
/*     */ 
/*     */   public Comparable getMinimumValue()
/*     */   {
/* 262 */     return (Comparable)getField("minValue", Comparable.class);
/*     */   }
/*     */ 
/*     */   public void setMinimumValue(Comparable value)
/*     */   {
/* 272 */     setField("minValue", (Serializable)value);
/*     */   }
/*     */ 
/*     */   public Comparable getMaximumValue()
/*     */   {
/* 277 */     return (Comparable)getField("maxValue", Comparable.class);
/*     */   }
/*     */ 
/*     */   public void setMaximumValue(Comparable value)
/*     */   {
/* 287 */     setField("maxValue", (Serializable)value);
/*     */   }
/*     */ 
/*     */   public String checkValidValue(Serializable value)
/*     */   {
/* 293 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean isMandatory()
/*     */   {
/* 298 */     Boolean result = (Boolean)getField("mandatory", Boolean.class);
/* 299 */     if (result == null)
/* 300 */       return false;
/* 301 */     return result.booleanValue();
/*     */   }
/*     */ 
/*     */   public void setMandatory(boolean flag)
/*     */   {
/* 311 */     if (flag)
/* 312 */       setField("mandatory", Boolean.valueOf(flag));
/*     */     else
/* 314 */       setField("mandatory", null);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 320 */     StringBuilder tmp = new StringBuilder("ManagedProperty");
/* 321 */     tmp.append('{');
/* 322 */     tmp.append(this.name);
/* 323 */     if (getMappedName() != null)
/*     */     {
/* 325 */       tmp.append(',');
/* 326 */       tmp.append(getMappedName());
/*     */     }
/* 328 */     tmp.append(",metaType=");
/* 329 */     tmp.append(getMetaType());
/* 330 */     tmp.append('}');
/* 331 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 337 */     return this.name.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 343 */     if (obj == this)
/* 344 */       return true;
/* 345 */     if ((obj == null) || (!(obj instanceof ManagedProperty))) {
/* 346 */       return false;
/*     */     }
/* 348 */     ManagedProperty other = (ManagedProperty)obj;
/* 349 */     return getName().equals(other.getName());
/*     */   }
/*     */ 
/*     */   private void init(ManagedObject managedObject, Fields fields)
/*     */   {
/* 362 */     if (fields == null) {
/* 363 */       throw new IllegalArgumentException("Null fields");
/*     */     }
/* 365 */     this.managedObject = managedObject;
/* 366 */     this.fields = fields;
/*     */ 
/* 368 */     this.name = ((String)getField("name", String.class));
/* 369 */     if (this.name == null)
/* 370 */       throw new IllegalArgumentException("No name in fields");
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 383 */     int version = in.readInt();
/* 384 */     if (version == 1)
/* 385 */       readVersion1(in);
/*     */     else
/* 387 */       throw new InvalidObjectException("Unknown version=" + version);
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream out)
/*     */     throws IOException
/*     */   {
/* 397 */     out.writeInt(1);
/* 398 */     out.writeObject(this.fields);
/* 399 */     out.writeObject(this.managedObject);
/* 400 */     out.writeObject(this.targetManagedObject);
/*     */   }
/*     */ 
/*     */   private void readVersion1(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 411 */     this.fields = ((Fields)in.readObject());
/* 412 */     this.name = ((String)getField("name", String.class));
/* 413 */     if (this.name == null)
/* 414 */       throw new IOException("No name in fields");
/* 415 */     this.managedObject = ((ManagedObject)in.readObject());
/* 416 */     this.targetManagedObject = ((ManagedObject)in.readObject());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.managed.plugins.ManagedPropertyImpl
 * JD-Core Version:    0.6.0
 */