/*     */ package org.jboss.managed.plugins;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.managed.api.DeploymentTemplateInfo;
/*     */ import org.jboss.managed.api.ManagedComponent;
/*     */ import org.jboss.managed.api.ManagedDeployment;
/*     */ import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ import org.jboss.managed.api.ManagedProperty;
/*     */ 
/*     */ public class ManagedDeploymentImpl
/*     */   implements ManagedDeployment, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String name;
/*     */   private String simpleName;
/*     */   private Set<String> types;
/*     */   private ManagedDeployment.DeploymentPhase phase;
/*     */   private ManagedDeployment parent;
/*     */   private Map<String, ManagedObject> unitMOs;
/*     */   private Map<String, ManagedProperty> properties;
/*  61 */   private Map<String, ManagedComponent> components = new HashMap();
/*     */ 
/*  63 */   private List<ManagedDeployment> children = new ArrayList();
/*     */ 
/*     */   public ManagedDeploymentImpl(String name, String simpleName, ManagedDeployment.DeploymentPhase phase, ManagedDeployment parent, Map<String, ManagedObject> unitMOs)
/*     */   {
/*  68 */     this.name = name;
/*  69 */     this.simpleName = simpleName;
/*  70 */     this.phase = phase;
/*  71 */     this.parent = parent;
/*  72 */     this.unitMOs = unitMOs;
/*  73 */     this.properties = new HashMap();
/*  74 */     for (ManagedObject mo : unitMOs.values())
/*     */     {
/*  76 */       this.properties.putAll(mo.getProperties());
/*     */     }
/*  78 */     if (parent != null)
/*     */     {
/*  80 */       parent.getChildren().add(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  86 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getSimpleName() {
/*  90 */     return this.simpleName;
/*     */   }
/*     */ 
/*     */   public boolean addType(String type)
/*     */   {
/*  95 */     return this.types.add(type);
/*     */   }
/*     */ 
/*     */   public Set<String> getTypes() {
/*  99 */     return this.types;
/*     */   }
/*     */ 
/*     */   public void setTypes(Set<String> types) {
/* 103 */     this.types = types;
/*     */   }
/*     */ 
/*     */   public ManagedDeployment.DeploymentPhase getDeploymentPhase()
/*     */   {
/* 108 */     return this.phase;
/*     */   }
/*     */ 
/*     */   public ManagedDeployment getParent() {
/* 112 */     return this.parent;
/*     */   }
/*     */ 
/*     */   public Set<String> getComponentTemplateNames()
/*     */   {
/* 118 */     return null;
/*     */   }
/*     */ 
/*     */   public void addComponent(String name, ManagedComponent comp) {
/* 122 */     this.components.put(name, comp);
/*     */   }
/*     */ 
/*     */   public ManagedComponent getComponent(String name) {
/* 126 */     return (ManagedComponent)this.components.get(name);
/*     */   }
/*     */ 
/*     */   public Map<String, ManagedComponent> getComponents()
/*     */   {
/* 131 */     return this.components;
/*     */   }
/*     */ 
/*     */   public boolean removeComponent(String name)
/*     */   {
/* 136 */     ManagedComponent mc = (ManagedComponent)this.components.remove(name);
/* 137 */     return mc != null;
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentTemplateNames()
/*     */   {
/* 143 */     return null;
/*     */   }
/*     */ 
/*     */   public List<ManagedDeployment> getChildren() {
/* 147 */     return this.children;
/*     */   }
/*     */ 
/*     */   public ManagedDeployment addModule(String deplymentBaseName, DeploymentTemplateInfo info)
/*     */   {
/* 153 */     return null;
/*     */   }
/*     */ 
/*     */   public Map<String, ManagedProperty> getProperties()
/*     */   {
/* 158 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public ManagedProperty getProperty(String name)
/*     */   {
/* 163 */     return (ManagedProperty)this.properties.get(name);
/*     */   }
/*     */ 
/*     */   public Set<String> getPropertyNames()
/*     */   {
/* 168 */     return this.properties.keySet();
/*     */   }
/*     */ 
/*     */   public Set<String> getManagedObjectNames()
/*     */   {
/* 173 */     return this.unitMOs.keySet();
/*     */   }
/*     */ 
/*     */   public Map<String, ManagedObject> getManagedObjects() {
/* 177 */     return this.unitMOs;
/*     */   }
/*     */ 
/*     */   public ManagedObject getManagedObject(String name) {
/* 181 */     return (ManagedObject)this.unitMOs.get(name);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 186 */     StringBuilder tmp = new StringBuilder(super.toString());
/* 187 */     tmp.append('{');
/* 188 */     tmp.append("name=");
/* 189 */     tmp.append(getName());
/* 190 */     tmp.append(", types=");
/* 191 */     tmp.append(this.types);
/* 192 */     tmp.append(", phase=");
/* 193 */     tmp.append(this.phase);
/* 194 */     tmp.append(", parent=");
/* 195 */     if (this.parent != null)
/*     */     {
/* 197 */       tmp.append("ManagedDeployment@");
/* 198 */       tmp.append(System.identityHashCode(this.parent));
/*     */     }
/*     */     else
/*     */     {
/* 202 */       tmp.append("null");
/*     */     }
/* 204 */     tmp.append(", components=");
/* 205 */     tmp.append(this.components);
/* 206 */     tmp.append(", children=");
/* 207 */     tmp.append(this.children);
/* 208 */     tmp.append('}');
/* 209 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.managed.plugins.ManagedDeploymentImpl
 * JD-Core Version:    0.6.0
 */