/*     */ package org.jboss.logging.util;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.Writer;
/*     */ import org.apache.log4j.Level;
/*     */ import org.apache.log4j.Logger;
/*     */ 
/*     */ public class LoggerWriter extends PrintWriter
/*     */ {
/*     */   private Logger logger;
/*     */   private Level level;
/*     */   private boolean inWrite;
/*     */   private boolean issuedWarning;
/*     */ 
/*     */   public LoggerWriter(Logger logger)
/*     */   {
/*  57 */     this(logger, Level.INFO);
/*     */   }
/*     */ 
/*     */   public LoggerWriter(Logger logger, Level level)
/*     */   {
/*  69 */     super(new InternalLoggerWriter(logger, level), true);
/*     */   }
/*     */ 
/*     */   static class InternalLoggerWriter extends Writer {
/*     */     private Logger logger;
/*     */     private Level level;
/*     */     private boolean closed;
/*     */ 
/*     */     public InternalLoggerWriter(Logger logger, Level level) {
/*  81 */       this.lock = logger;
/*     */ 
/*  83 */       this.logger = logger;
/*  84 */       this.level = level;
/*     */     }
/*     */ 
/*     */     public void write(char[] cbuf, int off, int len) throws IOException
/*     */     {
/*  89 */       if (this.closed) {
/*  90 */         throw new IOException("Called write on closed Writer");
/*     */       }
/*     */ 
/*  93 */       while ((len > 0) && ((cbuf[(len - 1)] == '\n') || (cbuf[(len - 1)] == '\r'))) {
/*  94 */         len--;
/*     */       }
/*  96 */       if (len > 0)
/*  97 */         this.logger.log(this.level, String.copyValueOf(cbuf, off, len));
/*     */     }
/*     */ 
/*     */     public void flush()
/*     */       throws IOException
/*     */     {
/* 104 */       if (this.closed)
/* 105 */         throw new IOException("Called flush on closed Writer");
/*     */     }
/*     */ 
/*     */     public void close()
/*     */     {
/* 110 */       this.closed = true;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.logging.util.LoggerWriter
 * JD-Core Version:    0.6.0
 */