/*     */ package org.jboss.logging.util;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import org.apache.log4j.Level;
/*     */ import org.apache.log4j.Logger;
/*     */ 
/*     */ public class LoggerStream extends PrintStream
/*     */ {
/*  49 */   public static final boolean TRACE = getBoolean(LoggerStream.class.getName() + ".trace", false);
/*     */   private Logger logger;
/*     */   private Level level;
/*     */   private boolean inWrite;
/*     */   private boolean issuedWarning;
/* 109 */   private ThreadLocal recursiveCheck = new ThreadLocal();
/*     */ 
/*     */   private static boolean getBoolean(String name, boolean defaultValue)
/*     */   {
/*  55 */     String value = System.getProperty(name, null);
/*  56 */     if (value == null)
/*  57 */       return defaultValue;
/*  58 */     return new Boolean(value).booleanValue();
/*     */   }
/*     */ 
/*     */   public LoggerStream(Logger logger)
/*     */   {
/*  71 */     this(logger, Level.INFO, System.out);
/*     */   }
/*     */ 
/*     */   public LoggerStream(Logger logger, Level level, PrintStream ps)
/*     */   {
/*  82 */     super(ps);
/*  83 */     this.logger = logger;
/*  84 */     this.level = level;
/*     */   }
/*     */ 
/*     */   public void println(String msg)
/*     */   {
/*  89 */     if (msg == null)
/*  90 */       msg = "null";
/*  91 */     byte[] bytes = msg.getBytes();
/*  92 */     write(bytes, 0, bytes.length);
/*     */   }
/*     */ 
/*     */   public void println(Object msg)
/*     */   {
/*  97 */     if (msg == null)
/*  98 */       msg = "null";
/*  99 */     byte[] bytes = msg.toString().getBytes();
/* 100 */     write(bytes, 0, bytes.length);
/*     */   }
/*     */ 
/*     */   public void write(byte b)
/*     */   {
/* 105 */     byte[] bytes = { b };
/* 106 */     write(bytes, 0, 1);
/*     */   }
/*     */ 
/*     */   public void write(byte[] b, int off, int len)
/*     */   {
/* 112 */     Boolean recursed = (Boolean)this.recursiveCheck.get();
/* 113 */     if ((recursed != null) && (recursed.equals(Boolean.TRUE)))
/*     */     {
/* 119 */       if (!this.issuedWarning)
/*     */       {
/* 121 */         String msg = "ERROR: invalid console appender config detected, console stream is looping";
/*     */         try
/*     */         {
/* 124 */           this.out.write(msg.getBytes());
/*     */         }
/*     */         catch (IOException ignore)
/*     */         {
/*     */         }
/* 129 */         this.issuedWarning = true;
/*     */       }
/* 131 */       return;
/*     */     }
/*     */ 
/* 135 */     while ((len > 0) && ((b[(len - 1)] == 10) || (b[(len - 1)] == 13)) && (len > off)) {
/* 136 */       len--;
/*     */     }
/*     */ 
/* 141 */     if (len != 0)
/*     */     {
/* 143 */       String msg = new String(b, off, len);
/* 144 */       this.recursiveCheck.set(Boolean.TRUE);
/* 145 */       if (TRACE)
/*     */       {
/* 147 */         this.logger.log(this.level, msg, new Throwable());
/*     */       }
/*     */       else
/*     */       {
/* 151 */         this.logger.log(this.level, msg);
/*     */       }
/* 153 */       this.recursiveCheck.set(Boolean.FALSE);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.logging.util.LoggerStream
 * JD-Core Version:    0.6.0
 */