/*    */ package org.jboss.logging.util;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.PrintWriter;
/*    */ import java.io.Writer;
/*    */ import org.jboss.logging.LoggerPlugin;
/*    */ 
/*    */ public class LoggerPluginWriter extends PrintWriter
/*    */ {
/*    */   public LoggerPluginWriter(LoggerPlugin logger)
/*    */   {
/* 47 */     super(new PluginWriter(logger), true);
/*    */   }
/*    */ 
/*    */   static class PluginWriter extends Writer {
/*    */     private LoggerPlugin logger;
/*    */     private boolean closed;
/*    */ 
/*    */     public PluginWriter(LoggerPlugin logger) {
/* 57 */       this.lock = logger;
/* 58 */       this.logger = logger;
/*    */     }
/*    */ 
/*    */     public void write(char[] cbuf, int off, int len)
/*    */       throws IOException
/*    */     {
/* 64 */       if (this.closed)
/*    */       {
/* 66 */         throw new IOException("Called write on closed Writer");
/*    */       }
/*    */ 
/* 69 */       while ((len > 0) && ((cbuf[(len - 1)] == '\n') || (cbuf[(len - 1)] == '\r')))
/*    */       {
/* 71 */         len--;
/*    */       }
/* 73 */       if (len > 0)
/*    */       {
/* 75 */         this.logger.info(String.copyValueOf(cbuf, off, len));
/*    */       }
/*    */     }
/*    */ 
/*    */     public void flush()
/*    */       throws IOException
/*    */     {
/* 82 */       if (this.closed)
/*    */       {
/* 84 */         throw new IOException("Called flush on closed Writer");
/*    */       }
/*    */     }
/*    */ 
/*    */     public void close()
/*    */     {
/* 90 */       this.closed = true;
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.logging.util.LoggerPluginWriter
 * JD-Core Version:    0.6.0
 */