/*     */ package org.jboss.logging.filter;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.URL;
/*     */ import org.apache.log4j.spi.Filter;
/*     */ import org.apache.log4j.spi.LoggingEvent;
/*     */ import org.jboss.util.collection.WeakSet;
/*     */ 
/*     */ public class TCLFilter extends Filter
/*     */ {
/*  88 */   private WeakSet matchSet = new WeakSet();
/*     */ 
/*  92 */   private WeakSet missSet = new WeakSet();
/*     */   private String deployURL;
/* 100 */   private boolean acceptOnMatch = true;
/*     */ 
/*     */   public boolean isAcceptOnMatch()
/*     */   {
/* 108 */     return this.acceptOnMatch;
/*     */   }
/*     */ 
/*     */   public void setAcceptOnMatch(boolean acceptOnMatch)
/*     */   {
/* 116 */     this.acceptOnMatch = acceptOnMatch;
/*     */   }
/*     */ 
/*     */   public String getDeployURL()
/*     */   {
/* 124 */     return this.deployURL;
/*     */   }
/*     */ 
/*     */   public void setDeployURL(String deployURL)
/*     */   {
/* 132 */     this.deployURL = deployURL;
/*     */   }
/*     */ 
/*     */   public int decide(LoggingEvent event)
/*     */   {
/* 142 */     int ok = -1;
/*     */ 
/* 144 */     if (this.acceptOnMatch == true)
/*     */     {
/* 148 */       ok = -1;
/*     */ 
/* 150 */       if (isMatchingTCL())
/*     */       {
/* 152 */         ok = 1;
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 160 */       ok = 1;
/*     */ 
/* 162 */       if (isMatchingTCL())
/*     */       {
/* 164 */         ok = -1;
/*     */       }
/*     */     }
/*     */ 
/* 168 */     return ok;
/*     */   }
/*     */ 
/*     */   private boolean isMatchingTCL()
/*     */   {
/* 184 */     ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/*     */ 
/* 186 */     if (this.matchSet.contains(tcl))
/*     */     {
/* 188 */       return true;
/*     */     }
/* 190 */     if (this.missSet.contains(tcl))
/*     */     {
/* 192 */       return false;
/*     */     }
/*     */ 
/* 198 */     ClassLoader cl = tcl;
/*     */ 
/* 200 */     boolean match = false;
/*     */ 
/* 202 */     while (cl != null)
/*     */     {
/* 206 */       URL[] urls = getClassLoaderURLs(cl);
/*     */ 
/* 208 */       for (int n = 0; n < urls.length; n++)
/*     */       {
/* 212 */         URL u = urls[n];
/*     */ 
/* 214 */         String file = u.getFile();
/*     */ 
/* 216 */         if (file.indexOf(this.deployURL) <= 0)
/*     */         {
/*     */           continue;
/*     */         }
/* 220 */         match = true;
/*     */ 
/* 222 */         break;
/*     */       }
/*     */ 
/* 228 */       cl = cl.getParent();
/*     */     }
/*     */ 
/* 232 */     if (match == true)
/*     */     {
/* 234 */       this.matchSet.add(tcl);
/*     */     }
/*     */     else
/*     */     {
/* 238 */       this.missSet.add(tcl);
/*     */     }
/*     */ 
/* 242 */     return match;
/*     */   }
/*     */ 
/*     */   private static URL[] getClassLoaderURLs(ClassLoader cl)
/*     */   {
/* 258 */     URL[] urls = new URL[0];
/*     */     try
/*     */     {
/* 264 */       Class returnType = urls.getClass();
/*     */ 
/* 266 */       Class[] parameterTypes = new Class[0];
/*     */ 
/* 268 */       Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
/*     */ 
/* 270 */       if (returnType.isAssignableFrom(getURLs.getReturnType()))
/*     */       {
/* 274 */         Object[] args = new Object[0];
/*     */ 
/* 276 */         urls = (URL[])(URL[])getURLs.invoke(cl, args);
/*     */       }
/*     */ 
/* 280 */       if ((urls == null) || (urls.length == 0))
/*     */       {
/* 284 */         getURLs = cl.getClass().getMethod("getClasspath", parameterTypes);
/*     */ 
/* 286 */         if (returnType.isAssignableFrom(getURLs.getReturnType()))
/*     */         {
/* 290 */           Object[] args = new Object[0];
/*     */ 
/* 292 */           urls = (URL[])(URL[])getURLs.invoke(cl, args);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/*     */ 
/* 306 */     return urls;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.logging.filter.TCLFilter
 * JD-Core Version:    0.6.0
 */