/*    */ package org.jboss.logging.appender;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import java.util.regex.Matcher;
/*    */ import java.util.regex.Pattern;
/*    */ import org.apache.log4j.spi.LoggingEvent;
/*    */ import org.apache.log4j.spi.TriggeringEventEvaluator;
/*    */ 
/*    */ public class RegexEventEvaluator
/*    */   implements TriggeringEventEvaluator
/*    */ {
/* 40 */   private HashMap regexMap = new HashMap();
/*    */ 
/*    */   public boolean isTriggeringEvent(LoggingEvent event)
/*    */   {
/* 53 */     String regex = (String)event.getMDC("RegexEventEvaluator");
/* 54 */     boolean isTriggeringEvent = false;
/* 55 */     if (regex != null)
/*    */     {
/* 58 */       Pattern re = (Pattern)this.regexMap.get(regex);
/* 59 */       if (re == null)
/*    */       {
/* 61 */         re = Pattern.compile(regex);
/* 62 */         this.regexMap.put(regex, re);
/*    */       }
/*    */ 
/* 65 */       if (re != null)
/*    */       {
/* 67 */         String msg = event.getRenderedMessage();
/* 68 */         if (msg != null)
/*    */         {
/* 70 */           Matcher m = re.matcher(msg);
/* 71 */           isTriggeringEvent = m.matches();
/*    */         }
/*    */       }
/*    */     }
/* 75 */     return isTriggeringEvent;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.logging.appender.RegexEventEvaluator
 * JD-Core Version:    0.6.0
 */