/*     */ package org.jboss.logging;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class Logger
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 4232175575988879434L;
/*  66 */   protected static String PLUGIN_CLASS_PROP = "org.jboss.logging.Logger.pluginClass";
/*     */   protected static final String LOG4J_PLUGIN_CLASS_NAME = "org.jboss.logging.log4j.Log4jLoggerPlugin";
/*  72 */   protected static Class pluginClass = null;
/*     */ 
/*  75 */   protected static String pluginClassName = null;
/*     */   private final String name;
/*  86 */   protected transient LoggerPlugin loggerDelegate = null;
/*     */ 
/*     */   public static String getPluginClassName()
/*     */   {
/*  94 */     return pluginClassName;
/*     */   }
/*     */ 
/*     */   public static void setPluginClassName(String pluginClassName)
/*     */   {
/* 104 */     if (!pluginClassName.equals(pluginClassName))
/*     */     {
/* 106 */       pluginClassName = pluginClassName;
/* 107 */       init();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Logger(String name)
/*     */   {
/* 118 */     this.name = name;
/* 119 */     this.loggerDelegate = getDelegatePlugin(name);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 129 */     return this.name;
/*     */   }
/*     */ 
/*     */   public LoggerPlugin getLoggerPlugin()
/*     */   {
/* 139 */     return this.loggerDelegate;
/*     */   }
/*     */ 
/*     */   public boolean isTraceEnabled()
/*     */   {
/* 150 */     return this.loggerDelegate.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public void trace(Object message)
/*     */   {
/* 160 */     this.loggerDelegate.trace(message);
/*     */   }
/*     */ 
/*     */   public void trace(Object message, Throwable t)
/*     */   {
/* 171 */     this.loggerDelegate.trace(message, t);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public boolean isDebugEnabled()
/*     */   {
/* 183 */     return this.loggerDelegate.isDebugEnabled();
/*     */   }
/*     */ 
/*     */   public void debug(Object message)
/*     */   {
/* 193 */     this.loggerDelegate.debug(message);
/*     */   }
/*     */ 
/*     */   public void debug(Object message, Throwable t)
/*     */   {
/* 204 */     this.loggerDelegate.debug(message, t);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public boolean isInfoEnabled()
/*     */   {
/* 216 */     return this.loggerDelegate.isInfoEnabled();
/*     */   }
/*     */ 
/*     */   public void info(Object message)
/*     */   {
/* 226 */     this.loggerDelegate.info(message);
/*     */   }
/*     */ 
/*     */   public void info(Object message, Throwable t)
/*     */   {
/* 237 */     this.loggerDelegate.info(message, t);
/*     */   }
/*     */ 
/*     */   public void warn(Object message)
/*     */   {
/* 247 */     this.loggerDelegate.warn(message);
/*     */   }
/*     */ 
/*     */   public void warn(Object message, Throwable t)
/*     */   {
/* 258 */     this.loggerDelegate.warn(message, t);
/*     */   }
/*     */ 
/*     */   public void error(Object message)
/*     */   {
/* 268 */     this.loggerDelegate.error(message);
/*     */   }
/*     */ 
/*     */   public void error(Object message, Throwable t)
/*     */   {
/* 279 */     this.loggerDelegate.error(message, t);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message)
/*     */   {
/* 289 */     this.loggerDelegate.fatal(message);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message, Throwable t)
/*     */   {
/* 300 */     this.loggerDelegate.fatal(message, t);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream stream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 313 */     stream.defaultReadObject();
/*     */ 
/* 316 */     if (pluginClass == null)
/*     */     {
/* 318 */       init();
/*     */     }
/* 320 */     this.loggerDelegate = getDelegatePlugin(this.name);
/*     */   }
/*     */ 
/*     */   public static Logger getLogger(String name)
/*     */   {
/* 331 */     return new Logger(name);
/*     */   }
/*     */ 
/*     */   public static Logger getLogger(String name, String suffix)
/*     */   {
/* 345 */     return new Logger(name + "." + suffix);
/*     */   }
/*     */ 
/*     */   public static Logger getLogger(Class clazz)
/*     */   {
/* 357 */     return new Logger(clazz.getName());
/*     */   }
/*     */ 
/*     */   public static Logger getLogger(Class clazz, String suffix)
/*     */   {
/* 371 */     return new Logger(clazz.getName() + "." + suffix);
/*     */   }
/*     */ 
/*     */   protected static LoggerPlugin getDelegatePlugin(String name)
/*     */   {
/* 382 */     LoggerPlugin plugin = null;
/*     */     try
/*     */     {
/* 385 */       plugin = (LoggerPlugin)pluginClass.newInstance();
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 389 */       plugin = new NullLoggerPlugin();
/*     */     }
/*     */     try
/*     */     {
/* 393 */       plugin.init(name);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 397 */       String extraInfo = e.getMessage();
/* 398 */       System.err.println("Failed to initalize plugin: " + plugin + (extraInfo != null ? ", cause: " + extraInfo : ""));
/*     */ 
/* 400 */       plugin = new NullLoggerPlugin();
/*     */     }
/*     */ 
/* 403 */     return plugin;
/*     */   }
/*     */ 
/*     */   protected static void init()
/*     */   {
/*     */     try
/*     */     {
/* 419 */       if (pluginClassName == null)
/*     */       {
/* 421 */         pluginClassName = System.getProperty(PLUGIN_CLASS_PROP, "org.jboss.logging.log4j.Log4jLoggerPlugin");
/*     */       }
/*     */ 
/* 425 */       ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 426 */       pluginClass = cl.loadClass(pluginClassName);
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 431 */       pluginClass = NullLoggerPlugin.class;
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  79 */     init();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.logging.Logger
 * JD-Core Version:    0.6.0
 */