/*     */ package org.jboss.logging;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.Timer;
/*     */ import java.util.TimerTask;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.Notification;
/*     */ import javax.management.ObjectName;
/*     */ import org.apache.log4j.Level;
/*     */ import org.apache.log4j.PropertyConfigurator;
/*     */ import org.apache.log4j.helpers.LogLog;
/*     */ import org.apache.log4j.xml.DOMConfigurator;
/*     */ import org.jboss.logging.util.LoggerStream;
/*     */ import org.jboss.logging.util.OnlyOnceErrorHandler;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.util.Strings;
/*     */ import org.jboss.util.ThrowableHandler;
/*     */ import org.jboss.util.ThrowableListener;
/*     */ import org.jboss.util.stream.Streams;
/*     */ 
/*     */ public class Log4jService extends ServiceMBeanSupport
/*     */   implements Log4jServiceMBean
/*     */ {
/*  79 */   public static final String DEFAULT_URL = System.getProperty(Log4jService.class.getName() + ".configURL", "resource:log4j.xml");
/*     */ 
/*  87 */   public static final boolean CATCH_SYSTEM_OUT = getBoolean(Log4jService.class.getName() + ".catchSystemOut", true);
/*     */ 
/*  95 */   public static final boolean CATCH_SYSTEM_ERR = getBoolean(Log4jService.class.getName() + ".catchSystemErr", true);
/*     */   private URL configURL;
/*     */   private int refreshPeriod;
/*     */   private ThrowableListenerLoggingAdapter throwableAdapter;
/*     */   private PrintStream out;
/*     */   private PrintStream err;
/* 125 */   private boolean catchSystemOut = CATCH_SYSTEM_OUT;
/*     */ 
/* 131 */   private boolean catchSystemErr = CATCH_SYSTEM_ERR;
/*     */ 
/* 134 */   private boolean log4jQuietMode = true;
/*     */   private Timer timer;
/*     */   private URLWatchTimerTask timerTask;
/*     */   private boolean initialized;
/*     */ 
/*     */   private static boolean getBoolean(String name, boolean defaultValue)
/*     */   {
/* 101 */     String value = System.getProperty(name, null);
/* 102 */     if (value == null)
/* 103 */       return defaultValue;
/* 104 */     return new Boolean(value).booleanValue();
/*     */   }
/*     */ 
/*     */   public Log4jService()
/*     */     throws MalformedURLException
/*     */   {
/* 158 */     this(DEFAULT_URL, 60);
/*     */   }
/*     */ 
/*     */   public Log4jService(URL url)
/*     */   {
/* 168 */     this(url, 60);
/*     */   }
/*     */ 
/*     */   public Log4jService(String url)
/*     */     throws MalformedURLException
/*     */   {
/* 178 */     this(Strings.toURL(url), 60);
/*     */   }
/*     */ 
/*     */   public Log4jService(String url, int refreshPeriod)
/*     */     throws MalformedURLException
/*     */   {
/* 190 */     this(Strings.toURL(url), refreshPeriod);
/*     */   }
/*     */ 
/*     */   public Log4jService(URL url, int refreshPeriod)
/*     */   {
/* 201 */     this.configURL = url;
/* 202 */     this.refreshPeriod = refreshPeriod;
/*     */   }
/*     */ 
/*     */   public void setCatchSystemOut(boolean flag)
/*     */   {
/* 214 */     this.catchSystemOut = flag;
/*     */   }
/*     */ 
/*     */   public boolean getCatchSystemOut()
/*     */   {
/* 226 */     return this.catchSystemOut;
/*     */   }
/*     */ 
/*     */   public void setCatchSystemErr(boolean flag)
/*     */   {
/* 238 */     this.catchSystemErr = flag;
/*     */   }
/*     */ 
/*     */   public boolean getCatchSystemErr()
/*     */   {
/* 250 */     return this.catchSystemErr;
/*     */   }
/*     */ 
/*     */   public boolean getLog4jQuietMode()
/*     */   {
/* 262 */     return this.log4jQuietMode;
/*     */   }
/*     */ 
/*     */   public void setLog4jQuietMode(boolean flag)
/*     */   {
/* 273 */     this.log4jQuietMode = flag;
/*     */   }
/*     */ 
/*     */   public int getRefreshPeriod()
/*     */   {
/* 283 */     return this.refreshPeriod;
/*     */   }
/*     */ 
/*     */   public void setRefreshPeriod(int refreshPeriod)
/*     */   {
/* 293 */     this.refreshPeriod = refreshPeriod;
/*     */   }
/*     */ 
/*     */   public URL getConfigurationURL()
/*     */   {
/* 303 */     return this.configURL;
/*     */   }
/*     */ 
/*     */   public void setConfigurationURL(URL url)
/*     */   {
/* 313 */     this.configURL = url;
/*     */   }
/*     */ 
/*     */   public void setLoggerLevel(String name, String levelName)
/*     */   {
/* 328 */     org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(name.trim());
/* 329 */     Level level = XLevel.toLevel(levelName.trim());
/*     */ 
/* 331 */     logger.setLevel(level);
/* 332 */     this.log.info("Level set to " + level + " for " + name);
/*     */   }
/*     */ 
/*     */   public void setLoggerLevels(String list, String levelName)
/*     */   {
/* 348 */     StringTokenizer stok = new StringTokenizer(list, ",");
/*     */ 
/* 350 */     while (stok.hasMoreTokens()) {
/* 351 */       String name = stok.nextToken();
/* 352 */       setLoggerLevel(name, levelName);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getLoggerLevel(String name)
/*     */   {
/* 365 */     org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(name);
/* 366 */     Level level = logger.getLevel();
/*     */ 
/* 368 */     if (level != null) {
/* 369 */       return level.toString();
/*     */     }
/* 371 */     return null;
/*     */   }
/*     */ 
/*     */   public void reconfigure()
/*     */     throws IOException
/*     */   {
/* 381 */     if (this.timerTask == null) {
/* 382 */       throw new IllegalStateException("Service stopped or not started");
/*     */     }
/* 384 */     this.timerTask.reconfigure();
/*     */   }
/*     */ 
/*     */   public void reconfigure(String url)
/*     */     throws IOException, MalformedURLException
/*     */   {
/* 397 */     setConfigurationURL(Strings.toURL(url));
/* 398 */     reconfigure();
/*     */   }
/*     */ 
/*     */   private void installSystemAdapters()
/*     */   {
/* 406 */     if (this.catchSystemOut)
/*     */     {
/* 408 */       org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger("STDOUT");
/* 409 */       this.out = System.out;
/* 410 */       System.setOut(new LoggerStream(logger, Level.INFO, this.out));
/* 411 */       this.log.debug("Installed System.out adapter");
/*     */     }
/*     */ 
/* 414 */     if (this.catchSystemErr)
/*     */     {
/* 416 */       org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger("STDERR");
/* 417 */       this.err = System.err;
/* 418 */       OnlyOnceErrorHandler.setOutput(this.err);
/* 419 */       System.setErr(new LoggerStream(logger, Level.ERROR, this.err));
/* 420 */       this.log.debug("Installed System.err adapter");
/*     */     }
/*     */   }
/*     */ 
/*     */   private void uninstallSystemAdapters()
/*     */   {
/* 427 */     if (this.out != null)
/*     */     {
/* 429 */       System.out.flush();
/* 430 */       System.setOut(this.out);
/* 431 */       this.log.debug("Removed System.out adapter");
/* 432 */       this.out = null;
/*     */     }
/*     */ 
/* 435 */     if (this.err != null)
/*     */     {
/* 437 */       System.err.flush();
/* 438 */       System.setErr(this.err);
/* 439 */       this.log.debug("Removed System.err adapter");
/* 440 */       this.err = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected ObjectName getObjectName(MBeanServer server, ObjectName name)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 452 */     return name == null ? OBJECT_NAME : name;
/*     */   }
/*     */ 
/*     */   private void setup() throws Exception
/*     */   {
/* 457 */     if (this.initialized) return;
/*     */ 
/* 459 */     this.timerTask = new URLWatchTimerTask(null);
/* 460 */     this.timerTask.run();
/* 461 */     this.timer = new Timer("Timer-" + getName(), true);
/* 462 */     this.timer.schedule(this.timerTask, 1000 * this.refreshPeriod, 1000 * this.refreshPeriod);
/*     */ 
/* 465 */     org.apache.log4j.Logger.getRootLogger();
/*     */ 
/* 468 */     this.throwableAdapter = new ThrowableListenerLoggingAdapter(null);
/* 469 */     ThrowableHandler.addThrowableListener(this.throwableAdapter);
/* 470 */     this.log.debug("Added ThrowableListener: " + this.throwableAdapter);
/*     */ 
/* 472 */     this.initialized = true;
/*     */   }
/*     */ 
/*     */   protected void createService() throws Exception
/*     */   {
/* 477 */     setup();
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/* 482 */     setup();
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 487 */     this.timer.cancel();
/* 488 */     this.timer = null;
/* 489 */     this.timerTask.cancel();
/* 490 */     this.timerTask = null;
/*     */ 
/* 493 */     ThrowableHandler.removeThrowableListener(this.throwableAdapter);
/* 494 */     this.throwableAdapter = null;
/*     */ 
/* 496 */     uninstallSystemAdapters();
/*     */ 
/* 499 */     this.initialized = false;
/*     */   }
/*     */ 
/*     */   protected void emitReconfigureNotification()
/*     */   {
/* 505 */     Notification n = new Notification("jboss.logging.log4j.reconfigure", this, getNextNotificationSequenceNumber(), "Log4j subsystem reconfigured");
/*     */ 
/* 507 */     n.setUserData(this.configURL);
/*     */ 
/* 509 */     super.sendNotification(n);
/*     */   }
/*     */ 
/*     */   private class URLWatchTimerTask extends TimerTask
/*     */   {
/* 560 */     private Logger log = Logger.getLogger(URLWatchTimerTask.class);
/*     */ 
/* 562 */     private long lastConfigured = -1L;
/*     */ 
/*     */     private URLWatchTimerTask() {
/*     */     }
/* 566 */     public void run() { this.log.trace("Checking if configuration changed");
/*     */ 
/* 568 */       boolean trace = this.log.isTraceEnabled();
/*     */       try
/*     */       {
/* 572 */         URLConnection conn = Log4jService.this.configURL.openConnection();
/* 573 */         if (trace) {
/* 574 */           this.log.trace("connection: " + conn);
/*     */         }
/* 576 */         long lastModified = conn.getLastModified();
/* 577 */         if (trace)
/*     */         {
/* 579 */           this.log.trace("last configured: " + this.lastConfigured);
/* 580 */           this.log.trace("last modified: " + lastModified);
/*     */         }
/*     */ 
/* 583 */         if (this.lastConfigured < lastModified)
/*     */         {
/* 585 */           reconfigure(conn);
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 590 */         this.log.warn("Failed to check URL: " + Log4jService.this.configURL, e);
/*     */       } }
/*     */ 
/*     */     public void reconfigure()
/*     */       throws IOException
/*     */     {
/* 596 */       URLConnection conn = Log4jService.this.configURL.openConnection();
/* 597 */       reconfigure(conn);
/*     */     }
/*     */ 
/*     */     private void reconfigure(URLConnection conn)
/*     */     {
/* 602 */       this.log.debug("Configuring from URL: " + Log4jService.this.configURL);
/*     */ 
/* 604 */       boolean xml = false;
/* 605 */       boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 608 */       String contentType = conn.getContentType();
/* 609 */       if (trace) {
/* 610 */         this.log.trace("content type: " + contentType);
/*     */       }
/* 612 */       if (contentType == null)
/*     */       {
/* 614 */         String filename = Log4jService.this.configURL.getFile().toLowerCase();
/* 615 */         if (trace) this.log.trace("filename: " + filename);
/*     */ 
/* 617 */         xml = filename.endsWith(".xml");
/*     */       }
/*     */       else
/*     */       {
/* 621 */         xml = contentType.equalsIgnoreCase("text/xml");
/* 622 */         xml |= contentType.equalsIgnoreCase("application/xml");
/*     */       }
/* 624 */       if (trace) {
/* 625 */         this.log.trace("reconfiguring; xml=" + xml);
/*     */       }
/*     */ 
/* 628 */       if (trace)
/*     */       {
/*     */         try
/*     */         {
/* 632 */           InputStream is = conn.getInputStream();
/* 633 */           Streams.copy(is, System.out);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 637 */           this.log.error("Failed to dump config", e);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 642 */       Log4jService.this.uninstallSystemAdapters();
/*     */ 
/* 644 */       if (xml)
/*     */       {
/* 646 */         DOMConfigurator.configure(Log4jService.this.configURL);
/*     */       }
/*     */       else
/*     */       {
/* 650 */         PropertyConfigurator.configure(Log4jService.this.configURL);
/*     */       }
/*     */ 
/* 656 */       LogLog.setQuietMode(Log4jService.this.log4jQuietMode);
/*     */ 
/* 659 */       Log4jService.this.installSystemAdapters();
/*     */ 
/* 662 */       this.lastConfigured = System.currentTimeMillis();
/*     */ 
/* 665 */       Log4jService.this.emitReconfigureNotification();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class ThrowableListenerLoggingAdapter
/*     */     implements ThrowableListener
/*     */   {
/* 523 */     private Logger log = Logger.getLogger(ThrowableListenerLoggingAdapter.class);
/*     */ 
/*     */     public void onThrowable(int type, Throwable t)
/*     */     {
/* 527 */       switch (type)
/*     */       {
/*     */       case 1:
/*     */       default:
/* 533 */         this.log.error("Unhandled Throwable", t);
/* 534 */         break;
/*     */       case 2:
/* 537 */         this.log.warn("Unhandled Throwable", t);
/* 538 */         break;
/*     */       case 0:
/* 542 */         this.log.trace("Ynhandled Throwable; status is unknown", t);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.logging.Log4jService
 * JD-Core Version:    0.6.0
 */