/*     */ package org.jboss.logging;
/*     */ 
/*     */ public class DynamicLogger extends Logger
/*     */ {
/*     */   private static final long serialVersionUID = -5963699806863917370L;
/*     */   public static final int LOG_LEVEL_NONE = 0;
/*     */   public static final int LOG_LEVEL_FATAL = 1;
/*     */   public static final int LOG_LEVEL_ERROR = 2;
/*     */   public static final int LOG_LEVEL_WARN = 3;
/*     */   public static final int LOG_LEVEL_INFO = 4;
/*     */   public static final int LOG_LEVEL_DEBUG = 5;
/*     */   public static final int LOG_LEVEL_TRACE = 6;
/*  62 */   public static final String[] LOG_LEVEL_STRINGS = { "NONE", "FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE" };
/*     */ 
/*  66 */   private int logLevel = 5;
/*     */ 
/*     */   public static DynamicLogger getDynamicLogger(String name)
/*     */   {
/*  76 */     return new DynamicLogger(name);
/*     */   }
/*     */ 
/*     */   public static DynamicLogger getDynamicLogger(String name, String suffix)
/*     */   {
/*  90 */     return new DynamicLogger(name + "." + suffix);
/*     */   }
/*     */ 
/*     */   public static DynamicLogger getDynamicLogger(Class clazz)
/*     */   {
/* 102 */     return new DynamicLogger(clazz.getName());
/*     */   }
/*     */ 
/*     */   public static DynamicLogger getDynamicLogger(Class clazz, String suffix)
/*     */   {
/* 116 */     return new DynamicLogger(clazz.getName() + "." + suffix);
/*     */   }
/*     */ 
/*     */   protected DynamicLogger(String name)
/*     */   {
/* 126 */     super(name);
/*     */   }
/*     */ 
/*     */   public void setLogLevel(int logLevel)
/*     */   {
/* 136 */     if ((logLevel >= 0) && (logLevel <= 6))
/*     */     {
/* 138 */       this.logLevel = logLevel;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getLogLevel()
/*     */   {
/* 149 */     return this.logLevel;
/*     */   }
/*     */ 
/*     */   public void setLogLevelAsString(String logLevelString)
/*     */   {
/* 159 */     if (logLevelString != null)
/*     */     {
/* 161 */       logLevelString = logLevelString.toUpperCase().trim();
/*     */ 
/* 163 */       for (int i = 0; i <= 6; i++)
/*     */       {
/* 165 */         if (!logLevelString.equals(LOG_LEVEL_STRINGS[i])) {
/*     */           continue;
/*     */         }
/* 168 */         this.logLevel = i;
/* 169 */         break;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getLogLevelAsString()
/*     */   {
/* 182 */     return LOG_LEVEL_STRINGS[this.logLevel];
/*     */   }
/*     */ 
/*     */   public void log(Object message)
/*     */   {
/* 192 */     switch (this.logLevel)
/*     */     {
/*     */     case 6:
/* 195 */       super.trace(message);
/* 196 */       break;
/*     */     case 5:
/* 199 */       super.debug(message);
/* 200 */       break;
/*     */     case 4:
/* 203 */       super.info(message);
/* 204 */       break;
/*     */     case 3:
/* 207 */       super.warn(message);
/* 208 */       break;
/*     */     case 2:
/* 211 */       super.error(message);
/* 212 */       break;
/*     */     case 1:
/* 215 */       super.fatal(message);
/* 216 */       break;
/*     */     case 0:
/*     */     }
/*     */   }
/*     */ 
/*     */   public void log(Object message, Throwable t)
/*     */   {
/* 233 */     switch (this.logLevel)
/*     */     {
/*     */     case 6:
/* 236 */       super.trace(message, t);
/* 237 */       break;
/*     */     case 5:
/* 240 */       super.debug(message, t);
/* 241 */       break;
/*     */     case 4:
/* 244 */       super.info(message, t);
/* 245 */       break;
/*     */     case 3:
/* 248 */       super.warn(message, t);
/* 249 */       break;
/*     */     case 2:
/* 252 */       super.error(message, t);
/* 253 */       break;
/*     */     case 1:
/* 256 */       super.fatal(message, t);
/* 257 */       break;
/*     */     case 0:
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.logging.DynamicLogger
 * JD-Core Version:    0.6.0
 */