/*     */ package org.jboss.kernel.spi.lazy;
/*     */ 
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ 
/*     */ public class LazyProxyFactory
/*     */ {
/*     */   private static LazyInitializer initializer;
/*  44 */   private static Map<String, String> initializerMap = new LinkedHashMap();
/*     */ 
/*     */   protected static LazyInitializer getInitializer(KernelConfigurator configurator)
/*     */   {
/*  59 */     if (initializer == null)
/*     */     {
/*  61 */       for (Map.Entry entry : initializerMap.entrySet())
/*     */       {
/*  63 */         if (testLibExists((String)entry.getKey()))
/*     */         {
/*  65 */           initializer = createInitializer(configurator, (String)entry.getValue());
/*  66 */           if (initializer != null)
/*     */             break;
/*     */         }
/*     */       }
/*     */     }
/*  71 */     if (initializer == null)
/*  72 */       throw new IllegalArgumentException("Cannot initialize LazyInitializater, check classpath for missing classes.");
/*  73 */     return initializer;
/*     */   }
/*     */ 
/*     */   protected static boolean testLibExists(String className)
/*     */   {
/*     */     try
/*     */     {
/*  86 */       return Class.forName(className) != null;
/*     */     }
/*     */     catch (ClassNotFoundException e) {
/*     */     }
/*  90 */     return false;
/*     */   }
/*     */ 
/*     */   protected static LazyInitializer createInitializer(KernelConfigurator configurator, String initializerClassName)
/*     */   {
/*     */     try
/*     */     {
/* 105 */       BeanInfo beanInfo = configurator.getBeanInfo(initializerClassName, LazyInitializer.class.getClassLoader());
/* 106 */       Object result = beanInfo.newInstance();
/* 107 */       return (LazyInitializer)LazyInitializer.class.cast(result);
/*     */     }
/*     */     catch (Throwable ignored)
/*     */     {
/*     */     }
/* 112 */     return null;
/*     */   }
/*     */ 
/*     */   public static Object getProxy(Kernel kernel, String bean, boolean exposeClass, Set<String> interfaces)
/*     */     throws Throwable
/*     */   {
/* 127 */     LazyInitializer lazyInitializer = getInitializer(kernel.getConfigurator());
/* 128 */     return lazyInitializer.initializeProxy(kernel, bean, exposeClass, interfaces);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  46 */     initializerMap.put("javassist.util.proxy.ProxyObject", "org.jboss.kernel.plugins.lazy.JavassistLazyInitializer");
/*  47 */     initializerMap.put("org.jboss.aop.proxy.container.AOPProxyFactoryParameters", "org.jboss.aop.microcontainer.lazy.JBossAOPLazyInitializer");
/*  48 */     initializerMap.put("java.lang.reflect.Proxy", "org.jboss.kernel.plugins.lazy.JDKLazyInitializer");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.spi.lazy.LazyProxyFactory
 * JD-Core Version:    0.6.0
 */