/*     */ package org.jboss.kernel.plugins.registry.basic;
/*     */ 
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryEntry;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryEntryAlreadyRegisteredException;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryEntryNotFoundException;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class BasicKernelRegistryFactory
/*     */   implements KernelRegistryPlugin
/*     */ {
/*  42 */   private static final Logger log = Logger.getLogger(BasicKernelRegistryFactory.class);
/*     */ 
/*  45 */   protected Map<Object, KernelRegistryEntry> entries = new ConcurrentHashMap();
/*     */ 
/*     */   public BasicKernelRegistryFactory()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void registerEntry(Object name, KernelRegistryEntry entry)
/*     */   {
/*  58 */     if (name == null)
/*  59 */       throw new IllegalArgumentException("Null name");
/*  60 */     if (entry == null) {
/*  61 */       throw new IllegalArgumentException("Null entry");
/*     */     }
/*  63 */     boolean trace = log.isTraceEnabled();
/*     */ 
/*  65 */     synchronized (this.entries)
/*     */     {
/*  67 */       if (this.entries.containsKey(name))
/*  68 */         throw new KernelRegistryEntryAlreadyRegisteredException("Already registered: " + name);
/*  69 */       this.entries.put(name, entry);
/*  70 */       entry.setName(name);
/*     */     }
/*     */ 
/*  73 */     if (trace)
/*  74 */       log.trace("Registered object: '" + entry + "' with name '" + name + "'");
/*     */   }
/*     */ 
/*     */   public KernelRegistryEntry unregisterEntry(Object name)
/*     */   {
/*  79 */     if (name == null) {
/*  80 */       throw new IllegalArgumentException("Null name");
/*     */     }
/*  82 */     boolean trace = log.isTraceEnabled();
/*     */     KernelRegistryEntry entry;
/*  86 */     synchronized (this.entries)
/*     */     {
/*  88 */       entry = (KernelRegistryEntry)this.entries.remove(name);
/*  89 */       if (entry == null) {
/*  90 */         throw new KernelRegistryEntryNotFoundException("Not found: " + name);
/*     */       }
/*     */     }
/*  93 */     if (trace) {
/*  94 */       log.trace("Unregistered name: '" + name + "'");
/*     */     }
/*  96 */     return entry;
/*     */   }
/*     */ 
/*     */   public KernelRegistryEntry getEntry(Object name)
/*     */   {
/* 101 */     if (name == null) {
/* 102 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 104 */     return (KernelRegistryEntry)this.entries.get(name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.registry.basic.BasicKernelRegistryFactory
 * JD-Core Version:    0.6.0
 */