/*    */ package org.jboss.kernel.plugins.registry.basic;
/*    */ 
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.kernel.plugins.registry.AbstractKernelRegistry;
/*    */ import org.jboss.kernel.spi.event.KernelEvent;
/*    */ import org.jboss.kernel.spi.registry.KernelRegistryEntry;
/*    */ import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
/*    */ 
/*    */ public class BasicKernelRegistry extends AbstractKernelRegistry
/*    */ {
/* 39 */   protected BasicKernelRegistryFactory defaultFactory = new BasicKernelRegistryFactory();
/*    */ 
/*    */   public BasicKernelRegistry()
/*    */     throws Exception
/*    */   {
/* 48 */     addKernelRegistryFactory(this.defaultFactory);
/*    */   }
/*    */ 
/*    */   public void registerEntry(Object name, KernelRegistryEntry entry)
/*    */   {
/* 53 */     Kernel.checkConfigure();
/*    */ 
/* 55 */     this.defaultFactory.registerEntry(name, entry);
/*    */ 
/* 57 */     Object target = entry.getTarget();
/* 58 */     if ((target != null) && ((target instanceof KernelRegistryPlugin)))
/*    */     {
/* 60 */       KernelRegistryPlugin factory = (KernelRegistryPlugin)target;
/* 61 */       addKernelRegistryFactory(factory);
/*    */     }
/*    */ 
/* 64 */     if (hasListeners())
/*    */     {
/* 66 */       KernelEvent event = createEvent("KERNEL_REGISTRY_REGISTERED", name);
/* 67 */       fireKernelEvent(event);
/*    */     }
/*    */   }
/*    */ 
/*    */   public KernelRegistryEntry unregisterEntry(Object name)
/*    */   {
/* 73 */     Kernel.checkConfigure();
/*    */ 
/* 75 */     KernelRegistryEntry entry = this.defaultFactory.unregisterEntry(name);
/*    */ 
/* 77 */     Object target = entry.getTarget();
/* 78 */     if ((target != null) && ((target instanceof KernelRegistryPlugin)))
/*    */     {
/* 80 */       KernelRegistryPlugin factory = (KernelRegistryPlugin)target;
/* 81 */       removeKernelRegistryFactory(factory);
/*    */     }
/*    */ 
/* 84 */     if (hasListeners())
/*    */     {
/* 86 */       KernelEvent event = createEvent("KERNEL_REGISTRY_UNREGISTERED", name);
/* 87 */       fireKernelEvent(event);
/*    */     }
/*    */ 
/* 90 */     return entry;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.registry.basic.BasicKernelRegistry
 * JD-Core Version:    0.6.0
 */