/*    */ package org.jboss.kernel.plugins.lazy;
/*    */ 
/*    */ import java.lang.reflect.InvocationHandler;
/*    */ import java.lang.reflect.Method;
/*    */ import java.lang.reflect.Proxy;
/*    */ import java.util.Set;
/*    */ import org.jboss.beans.info.spi.BeanInfo;
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.kernel.plugins.config.Configurator;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ import org.jboss.kernel.spi.registry.KernelBus;
/*    */ import org.jboss.reflect.spi.ClassInfo;
/*    */ 
/*    */ public class JDKLazyInitializer extends AbstractLazyInitializer
/*    */ {
/*    */   public Object initializeProxy(Kernel kernel, String bean, boolean exposeClass, Set<String> interfaces)
/*    */     throws Throwable
/*    */   {
/* 44 */     if (exposeClass)
/* 45 */       throw new IllegalArgumentException("Cannot expose class via JDK LazyInitializer.");
/* 46 */     if ((interfaces == null) || (interfaces.isEmpty())) {
/* 47 */       throw new IllegalArgumentException("Null interfaces.");
/*    */     }
/* 49 */     KernelControllerContext context = getKernelControllerContext(kernel, bean);
/* 50 */     BeanInfo beanInfo = context.getBeanInfo();
/* 51 */     if (beanInfo == null)
/* 52 */       throw new IllegalArgumentException("Cannot proxy factory beans.");
/* 53 */     LazyHandler lazyHandler = new LazyHandler(bean, kernel.getBus(), beanInfo.getClassInfo().getType());
/* 54 */     ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
/* 55 */     return Proxy.newProxyInstance(getClass().getClassLoader(), getClasses(kernel.getConfigurator(), interfaces, cl), lazyHandler);
/*    */   }
/*    */ 
/*    */   public class LazyHandler extends AbstractLazyInitializer.AbstractInvokeHandler
/*    */     implements InvocationHandler
/*    */   {
/*    */     public LazyHandler(String bean, KernelBus bus, Class proxyClass)
/*    */     {
/* 65 */       super(bean, bus, proxyClass);
/*    */     }
/*    */ 
/*    */     public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
/*    */     {
/* 70 */       return executeInvoke(proxy, method, args);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.lazy.JDKLazyInitializer
 * JD-Core Version:    0.6.0
 */