/*     */ package org.jboss.kernel.plugins.event;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.ListIterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import org.jboss.kernel.spi.event.KernelEvent;
/*     */ import org.jboss.kernel.spi.event.KernelEventEmitter;
/*     */ import org.jboss.kernel.spi.event.KernelEventFilter;
/*     */ import org.jboss.kernel.spi.event.KernelEventListener;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class AbstractEventEmitter
/*     */   implements KernelEventEmitter
/*     */ {
/*  46 */   private static final Logger log = Logger.getLogger(AbstractEventEmitter.class);
/*     */ 
/*  49 */   protected static final Object NULL = new Object();
/*     */ 
/*  52 */   protected static final KernelEventFilter NULL_FILTER = new KernelEventFilter()
/*     */   {
/*     */     public boolean wantEvent(KernelEvent event, Object handback)
/*     */     {
/*  56 */       return false;
/*     */     }
/*  52 */   };
/*     */ 
/*  61 */   protected Map<KernelEventFilter, Map<Object, List<KernelEventListener>>> eventListenerRegistry = new ConcurrentHashMap();
/*     */ 
/*  64 */   private long emitterSequence = 0L;
/*     */ 
/*     */   public boolean hasListeners()
/*     */   {
/*  73 */     return !this.eventListenerRegistry.isEmpty();
/*     */   }
/*     */ 
/*     */   public KernelEvent createEvent(String type, Object context)
/*     */   {
/*  85 */     return new AbstractEvent(this, type, nextEmitterSequence(), System.currentTimeMillis(), context);
/*     */   }
/*     */ 
/*     */   public void registerListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable
/*     */   {
/*  90 */     KernelEventFilter filterObject = filter == null ? NULL_FILTER : filter;
/*  91 */     Object handbackObject = handback == null ? NULL : handback;
/*     */ 
/*  93 */     synchronized (this.eventListenerRegistry)
/*     */     {
/*  95 */       Map handbacks = (Map)this.eventListenerRegistry.get(filterObject);
/*  96 */       if (handbacks == null)
/*     */       {
/*  98 */         handbacks = new ConcurrentHashMap();
/*  99 */         this.eventListenerRegistry.put(filterObject, handbacks);
/*     */       }
/* 101 */       List listeners = (List)handbacks.get(handbackObject);
/* 102 */       if (listeners == null)
/*     */       {
/* 104 */         listeners = new CopyOnWriteArrayList();
/* 105 */         handbacks.put(handbackObject, listeners);
/*     */       }
/* 107 */       listeners.add(listener);
/* 108 */       if (log.isTraceEnabled())
/* 109 */         log.trace("Registered listener: " + listener + " with filter=" + filter + " handback=" + handback + " on object " + this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void unregisterListener(KernelEventListener listener, KernelEventFilter filter, Object handback)
/*     */     throws Throwable
/*     */   {
/* 116 */     KernelEventFilter filterObject = filter == null ? NULL_FILTER : filter;
/* 117 */     Object handbackObject = handback == null ? NULL : handback;
/*     */ 
/* 119 */     synchronized (this.eventListenerRegistry)
/*     */     {
/* 121 */       Map handbacks = (Map)this.eventListenerRegistry.get(filterObject);
/* 122 */       if (handbacks != null)
/*     */       {
/* 124 */         List listeners = (List)handbacks.get(handbackObject);
/* 125 */         if ((listeners != null) && (listeners.remove(listener)))
/*     */         {
/* 127 */           if (log.isTraceEnabled())
/* 128 */             log.trace("Unregistered listener: " + listener + " with filter=" + filter + " handback=" + handback + " on object " + this);
/* 129 */           return;
/*     */         }
/*     */       }
/*     */     }
/* 133 */     throw new IllegalStateException("Listener not registered.");
/*     */   }
/*     */ 
/*     */   public void fireKernelEvent(KernelEvent event)
/*     */   {
/* 138 */     if (log.isTraceEnabled())
/* 139 */       log.trace("Firing event: " + event + " on object " + this);
/*     */     Iterator i;
/* 140 */     if (!this.eventListenerRegistry.isEmpty())
/*     */     {
/* 142 */       for (i = this.eventListenerRegistry.entrySet().iterator(); i.hasNext(); )
/*     */       {
/* 144 */         Map.Entry registryEntry = (Map.Entry)i.next();
/*     */ 
/* 146 */         Map handbacks = (Map)registryEntry.getValue();
/* 147 */         if (handbacks != null)
/*     */         {
/* 149 */           filter = null;
/* 150 */           Object filterObject = registryEntry.getKey();
/* 151 */           if (filterObject != NULL_FILTER) {
/* 152 */             filter = (KernelEventFilter)filterObject;
/*     */           }
/* 154 */           for (j = handbacks.entrySet().iterator(); j.hasNext(); )
/*     */           {
/* 156 */             Map.Entry handbackEntry = (Map.Entry)j.next();
/* 157 */             List listeners = (List)handbackEntry.getValue();
/* 158 */             if (listeners != null)
/*     */             {
/* 160 */               handback = handbackEntry.getKey();
/* 161 */               if (handback == NULL) {
/* 162 */                 handback = null;
/*     */               }
/* 164 */               for (k = listeners.listIterator(); k.hasNext(); )
/*     */               {
/* 166 */                 KernelEventListener listener = (KernelEventListener)k.next();
/*     */                 try
/*     */                 {
/* 169 */                   if ((filter == null) || (filter.wantEvent(event, handback)))
/* 170 */                     fireKernelEvent(listener, event, handback);
/*     */                 }
/*     */                 catch (Throwable t)
/*     */                 {
/* 174 */                   log.debug("Ignored unhandled throwable: ", t);
/*     */                 }
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     KernelEventFilter filter;
/*     */     Iterator j;
/*     */     Object handback;
/*     */     ListIterator k;
/*     */   }
/*     */ 
/*     */   protected void fireKernelEvent(KernelEventListener listener, KernelEvent event, Object handback) {
/* 193 */     listener.onEvent(event, handback);
/*     */   }
/*     */ 
/*     */   protected long nextEmitterSequence()
/*     */   {
/* 203 */     synchronized (this.eventListenerRegistry)
/*     */     {
/* 205 */       return this.emitterSequence++;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.event.AbstractEventEmitter
 * JD-Core Version:    0.6.0
 */