/*    */ package org.jboss.kernel.plugins.deployment.xml;
/*    */ 
/*    */ import javax.xml.namespace.NamespaceContext;
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.beans.metadata.plugins.AbstractCallbackMetaData;
/*    */ import org.jboss.beans.metadata.plugins.InstallCallbackMetaData;
/*    */ import org.jboss.beans.metadata.plugins.UninstallCallbackMetaData;
/*    */ import org.jboss.dependency.spi.Cardinality;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*    */ import org.xml.sax.Attributes;
/*    */ 
/*    */ public class CallbackHandler extends DefaultElementHandler
/*    */ {
/* 44 */   public static final CallbackHandler HANDLER = new CallbackHandler();
/*    */ 
/*    */   public Object startElement(Object parent, QName name, ElementBinding element)
/*    */   {
/* 48 */     QName qname = element.getQName();
/* 49 */     boolean isInstall = qname.getLocalPart().startsWith("in");
/* 50 */     return isInstall ? new InstallCallbackMetaData() : new UninstallCallbackMetaData();
/*    */   }
/*    */ 
/*    */   public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*    */   {
/* 55 */     AbstractCallbackMetaData callbackMetaData = (AbstractCallbackMetaData)o;
/* 56 */     for (int i = 0; i < attrs.getLength(); i++)
/*    */     {
/* 58 */       String localName = attrs.getLocalName(i);
/* 59 */       if ("property".equals(localName))
/* 60 */         callbackMetaData.setProperty(attrs.getValue(i));
/* 61 */       else if ("method".equals(localName))
/* 62 */         callbackMetaData.setMethodName(attrs.getValue(i));
/* 63 */       else if ("state".equals(localName))
/* 64 */         callbackMetaData.setDependentState(new ControllerState(attrs.getValue(i)));
/* 65 */       else if ("whenRequired".equals(localName))
/* 66 */         callbackMetaData.setWhenRequired(new ControllerState(attrs.getValue(i)));
/* 67 */       else if ("signature".equals(localName))
/* 68 */         callbackMetaData.setSignature(attrs.getValue(i));
/* 69 */       else if ("cardinality".equals(localName))
/* 70 */         callbackMetaData.setCardinality(Cardinality.toCardinality(attrs.getValue(i)));
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object endElement(Object o, QName qName, ElementBinding element)
/*    */   {
/* 76 */     AbstractCallbackMetaData callbackMetaData = (AbstractCallbackMetaData)o;
/* 77 */     if ((callbackMetaData.getMethodName() == null) && (callbackMetaData.getProperty() == null))
/* 78 */       throw new IllegalArgumentException("Install/uninstall callback should have method or property attribute.");
/* 79 */     if ((callbackMetaData.getMethodName() != null) && (callbackMetaData.getProperty() != null))
/* 80 */       throw new IllegalArgumentException("Install/uninstall callback should have exactly one of method or property attribute.");
/* 81 */     return callbackMetaData;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.xml.CallbackHandler
 * JD-Core Version:    0.6.0
 */