/*     */ package org.jboss.kernel.plugins.deployment.xml;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.deployment.AbstractKernelDeployer;
/*     */ import org.jboss.kernel.spi.deployment.KernelDeployment;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;
/*     */ 
/*     */ public class BeanXMLDeployer extends AbstractKernelDeployer
/*     */ {
/*  47 */   private static final Logger log = Logger.getLogger(BeanXMLDeployer.class);
/*     */ 
/*  50 */   private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
/*     */ 
/*  53 */   private static final SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
/*     */ 
/*     */   public BeanXMLDeployer(Kernel kernel)
/*     */     throws Throwable
/*     */   {
/*  63 */     super(kernel);
/*     */   }
/*     */ 
/*     */   public KernelDeployment deploy(URL url)
/*     */     throws Throwable
/*     */   {
/*  75 */     boolean trace = log.isTraceEnabled();
/*     */ 
/*  77 */     if (url == null) {
/*  78 */       throw new IllegalArgumentException("Null url");
/*     */     }
/*  80 */     if (trace) {
/*  81 */       log.trace("Parsing " + url);
/*     */     }
/*  83 */     long start = System.currentTimeMillis();
/*     */ 
/*  85 */     Unmarshaller unmarshaller = factory.newUnmarshaller();
/*  86 */     KernelDeployment deployment = (KernelDeployment)unmarshaller.unmarshal(url.toString(), resolver);
/*  87 */     if (deployment == null)
/*  88 */       throw new RuntimeException("The xml " + url + " is not well formed!");
/*  89 */     deployment.setName(url.toString());
/*     */ 
/*  91 */     long now = System.currentTimeMillis();
/*  92 */     log.debug("Parsing " + url + " took " + (now - start) + " milliseconds");
/*     */ 
/*  94 */     if (trace)
/*  95 */       log.trace("Deploying " + deployment);
/*  96 */     deploy(deployment);
/*     */ 
/*  98 */     now = System.currentTimeMillis();
/*  99 */     log.debug("Deploying " + url + " took " + (now - start) + " milliseconds");
/*     */ 
/* 101 */     if (trace) {
/* 102 */       log.trace("Deployed " + deployment.getInstalledContexts());
/*     */     }
/* 104 */     return deployment;
/*     */   }
/*     */ 
/*     */   public KernelDeployment deploy(String deploymentName, InputStream stream)
/*     */     throws Throwable
/*     */   {
/* 117 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 119 */     if (trace)
/* 120 */       log.trace("Parsing " + deploymentName);
/* 121 */     Unmarshaller unmarshaller = factory.newUnmarshaller();
/* 122 */     KernelDeployment deployment = (KernelDeployment)unmarshaller.unmarshal(stream, resolver);
/* 123 */     if (deployment == null)
/* 124 */       throw new RuntimeException("The deployment " + deploymentName + " is not well formed!");
/* 125 */     deployment.setName(deploymentName);
/*     */ 
/* 127 */     if (trace)
/* 128 */       log.trace("Deploying " + deployment);
/* 129 */     deploy(deployment);
/* 130 */     if (trace) {
/* 131 */       log.trace("Deployed " + deployment.getInstalledContexts());
/*     */     }
/* 133 */     return deployment;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer
 * JD-Core Version:    0.6.0
 */