/*    */ package org.jboss.kernel.plugins.deployment.xml;
/*    */ 
/*    */ import javax.xml.namespace.NamespaceContext;
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*    */ import org.jboss.beans.metadata.spi.AutowireType;
/*    */ import org.jboss.beans.metadata.spi.ConstructorMetaData;
/*    */ import org.jboss.dependency.spi.ControllerMode;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*    */ import org.xml.sax.Attributes;
/*    */ 
/*    */ public class BeanHandler extends DefaultElementHandler
/*    */ {
/* 44 */   public static final BeanHandler HANDLER = new BeanHandler();
/*    */ 
/*    */   public Object startElement(Object parent, QName name, ElementBinding element)
/*    */   {
/* 48 */     return new AbstractBeanMetaData();
/*    */   }
/*    */ 
/*    */   public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*    */   {
/* 53 */     AbstractBeanMetaData bean = (AbstractBeanMetaData)o;
/* 54 */     for (int i = 0; i < attrs.getLength(); i++)
/*    */     {
/* 56 */       String localName = attrs.getLocalName(i);
/* 57 */       if ("name".equals(localName))
/* 58 */         bean.setName(attrs.getValue(i));
/* 59 */       else if ("class".equals(localName))
/* 60 */         bean.setBean(attrs.getValue(i));
/* 61 */       else if ("mode".equals(localName))
/* 62 */         bean.setMode(new ControllerMode(attrs.getValue(i)));
/* 63 */       else if ("parent".equals(localName))
/* 64 */         bean.setParent(attrs.getValue(i));
/* 65 */       else if ("abstract".equals(localName))
/* 66 */         bean.setAbstract(Boolean.parseBoolean(attrs.getValue(i)));
/* 67 */       else if ("autowire-type".equals(localName))
/* 68 */         bean.setAutowireType(AutowireType.getInstance(attrs.getValue(i)));
/* 69 */       else if ("autowire-candidate".equals(localName))
/* 70 */         bean.setAutowireCandidate(Boolean.parseBoolean(attrs.getValue(i)));
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object endElement(Object o, QName qName, ElementBinding element)
/*    */   {
/* 76 */     AbstractBeanMetaData bean = (AbstractBeanMetaData)o;
/* 77 */     if ((bean.getBean() == null) && (!bean.isAbstract()) && (bean.getParent() == null))
/*    */     {
/* 79 */       ConstructorMetaData constructor = bean.getConstructor();
/* 80 */       if (constructor == null)
/* 81 */         throw new IllegalArgumentException("Bean should have a class attribute or a constructor element.");
/* 82 */       if (constructor.getFactoryMethod() == null)
/*    */       {
/* 84 */         if (constructor.getValue() == null)
/* 85 */           throw new IllegalArgumentException("Bean should have a class attribute or the constructor element should have either a factoryMethod attribute or embedded value.");
/*    */       }
/* 87 */       else if ((constructor.getFactory() == null) && (constructor.getFactoryClass() == null))
/* 88 */         throw new IllegalArgumentException("Bean should have a class attribute or the constructor element should have one of a factoryClass attribute or a factory element, or embedded value.");
/*    */     }
/* 90 */     return bean;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.xml.BeanHandler
 * JD-Core Version:    0.6.0
 */