/*     */ package org.jboss.kernel.plugins.deployment.xml;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.util.Collection;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.deployment.BasicKernelDeployer;
/*     */ import org.jboss.kernel.spi.deployment.KernelDeployment;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;
/*     */ 
/*     */ public class BasicXMLDeployer extends BasicKernelDeployer
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(BasicXMLDeployer.class);
/*     */ 
/*  52 */   private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
/*     */ 
/*  55 */   private static final SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
/*     */ 
/*  58 */   private Map<String, KernelDeployment> deploymentsByName = new ConcurrentHashMap();
/*     */ 
/*     */   public BasicXMLDeployer(Kernel kernel)
/*     */   {
/*  67 */     this(kernel, null);
/*     */   }
/*     */ 
/*     */   public BasicXMLDeployer(Kernel kernel, ControllerMode mode)
/*     */   {
/*  78 */     super(kernel, mode);
/*     */   }
/*     */ 
/*     */   public Collection getDeploymentNames()
/*     */   {
/*  83 */     return this.deploymentsByName.keySet();
/*     */   }
/*     */ 
/*     */   public void deploy(KernelDeployment deployment) throws Throwable
/*     */   {
/*  88 */     super.deploy(deployment);
/*  89 */     this.deploymentsByName.put(deployment.getName(), deployment);
/*     */   }
/*     */ 
/*     */   public void undeploy(KernelDeployment deployment)
/*     */   {
/*  94 */     this.deploymentsByName.remove(deployment.getName());
/*  95 */     super.undeploy(deployment);
/*     */   }
/*     */ 
/*     */   public void undeploy(URL url)
/*     */   {
/* 106 */     if (url == null)
/* 107 */       throw new IllegalArgumentException("Null url");
/* 108 */     undeploy(url.toString());
/*     */   }
/*     */ 
/*     */   public void undeploy(String name)
/*     */   {
/* 119 */     if (name == null)
/* 120 */       throw new IllegalArgumentException("Null name");
/* 121 */     KernelDeployment deployment = (KernelDeployment)this.deploymentsByName.remove(name);
/* 122 */     if (deployment == null)
/* 123 */       throw new IllegalStateException("Unknown deployment " + name);
/* 124 */     undeploy(deployment);
/*     */   }
/*     */ 
/*     */   public KernelDeployment deploy(URL url)
/*     */     throws Throwable
/*     */   {
/* 136 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 138 */     if (url == null) {
/* 139 */       throw new IllegalArgumentException("Null url");
/*     */     }
/* 141 */     if (trace) {
/* 142 */       log.trace("Parsing " + url);
/*     */     }
/* 144 */     long start = System.currentTimeMillis();
/*     */ 
/* 146 */     Unmarshaller unmarshaller = factory.newUnmarshaller();
/* 147 */     KernelDeployment deployment = (KernelDeployment)unmarshaller.unmarshal(url.toString(), resolver);
/* 148 */     if (deployment == null)
/* 149 */       throw new RuntimeException("The xml " + url + " is not well formed!");
/* 150 */     deployment.setName(url.toString());
/*     */ 
/* 152 */     if (trace)
/*     */     {
/* 154 */       long now = System.currentTimeMillis();
/* 155 */       log.trace("Parsing " + url + " took " + (now - start) + " milliseconds");
/*     */     }
/*     */ 
/* 158 */     deploy(deployment);
/*     */ 
/* 160 */     if (trace)
/*     */     {
/* 162 */       long now = System.currentTimeMillis();
/* 163 */       log.trace("Deploying " + url + " took " + (now - start) + " milliseconds");
/*     */     }
/*     */ 
/* 166 */     return deployment;
/*     */   }
/*     */ 
/*     */   public KernelDeployment deploy(String deploymentName, InputStream stream)
/*     */     throws Throwable
/*     */   {
/* 179 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 181 */     if (trace)
/* 182 */       log.trace("Parsing " + deploymentName);
/* 183 */     Unmarshaller unmarshaller = factory.newUnmarshaller();
/* 184 */     KernelDeployment deployment = (KernelDeployment)unmarshaller.unmarshal(stream, resolver);
/* 185 */     if (deployment == null)
/* 186 */       throw new RuntimeException("The deployment " + deploymentName + " is not well formed!");
/* 187 */     deployment.setName(deploymentName);
/*     */ 
/* 189 */     deploy(deployment);
/*     */ 
/* 191 */     return deployment;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer
 * JD-Core Version:    0.6.0
 */