/*     */ package org.jboss.kernel.plugins.deployment.props;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import java.util.TreeMap;
/*     */ import org.jboss.kernel.plugins.deployment.props.vertex.DefaultVertexFactory;
/*     */ import org.jboss.kernel.spi.deployment.KernelDeployment;
/*     */ import org.jboss.util.graph.Graph;
/*     */ import org.jboss.util.graph.Vertex;
/*     */ 
/*     */ public class PropertiesGraphFactory
/*     */ {
/*     */   private Graph<String> graph;
/*     */   private DeploymentVertex root;
/*  47 */   private VertexFactory vertexFactory = new DefaultVertexFactory();
/*     */ 
/*     */   public PropertiesGraphFactory(Properties properties)
/*     */   {
/*  51 */     if (properties == null) {
/*  52 */       throw new IllegalArgumentException("Null properties.");
/*     */     }
/*  54 */     buildGraph(toMap(properties));
/*     */   }
/*     */ 
/*     */   public PropertiesGraphFactory(Map<String, String> properties)
/*     */   {
/*  59 */     if (properties == null) {
/*  60 */       throw new IllegalArgumentException("Null properties.");
/*     */     }
/*  62 */     buildGraph(properties);
/*     */   }
/*     */ 
/*     */   public KernelDeployment build()
/*     */   {
/*  72 */     this.graph.depthFirstSearch(this.root, this.vertexFactory.visitor());
/*  73 */     return this.root.get();
/*     */   }
/*     */ 
/*     */   protected static Map<String, String> toMap(Properties properties)
/*     */   {
/*  84 */     Map map = new TreeMap();
/*  85 */     for (Iterator i$ = properties.keySet().iterator(); i$.hasNext(); ) { Object key = i$.next();
/*     */ 
/*  87 */       String ks = key.toString();
/*  88 */       map.put(ks, properties.getProperty(ks));
/*     */     }
/*  90 */     return map;
/*     */   }
/*     */ 
/*     */   protected void buildGraph(Map<String, String> properties)
/*     */   {
/* 100 */     this.graph = new Graph();
/* 101 */     this.root = this.vertexFactory.rootVertex();
/* 102 */     this.graph.setRootVertex(this.root);
/* 103 */     for (String key : properties.keySet())
/*     */     {
/* 105 */       String value = (String)properties.get(key);
/* 106 */       buildVertices(this.root, 0, key, value, 0);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void buildVertices(Vertex<String> previous, int index, String key, String value, int level)
/*     */   {
/* 122 */     int p = key.indexOf('.', index + 1);
/* 123 */     int end = p > 0 ? p : key.length();
/* 124 */     String name = key.substring(0, end);
/*     */ 
/* 126 */     Vertex current = this.graph.findVertexByName(name);
/* 127 */     if (current == null)
/*     */     {
/* 129 */       current = this.vertexFactory.createVertex(level, name);
/* 130 */       this.graph.addVertex(current);
/*     */     }
/* 132 */     this.graph.addEdge(previous, current, level);
/*     */ 
/* 134 */     if (p < 0)
/*     */     {
/* 136 */       Vertex valueVertex = this.vertexFactory.valueVertex(value);
/* 137 */       this.graph.addVertex(valueVertex);
/* 138 */       this.graph.addEdge(current, valueVertex, -1);
/*     */     }
/*     */     else {
/* 141 */       buildVertices(current, p, key, value, level + 1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setVertexFactory(VertexFactory vertexFactory)
/*     */   {
/* 151 */     this.vertexFactory = vertexFactory;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 156 */     return this.graph.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.props.PropertiesGraphFactory
 * JD-Core Version:    0.6.0
 */