/*    */ package org.jboss.kernel.plugins.deployment.props;
/*    */ 
/*    */ import java.util.Iterator;
/*    */ import java.util.Map;
/*    */ import java.util.Properties;
/*    */ import java.util.Set;
/*    */ import java.util.TreeMap;
/*    */ import org.jboss.kernel.spi.deployment.KernelDeployment;
/*    */ 
/*    */ public class DeploymentBuilder
/*    */ {
/*    */   private PropertiesGraphFactory graphFactory;
/*    */ 
/*    */   public DeploymentBuilder(Properties properties)
/*    */   {
/* 41 */     buildGraph(toMap(properties));
/*    */   }
/*    */ 
/*    */   public DeploymentBuilder(Map<String, String> properties)
/*    */   {
/* 46 */     buildGraph(properties);
/*    */   }
/*    */ 
/*    */   protected static Map<String, String> toMap(Properties properties)
/*    */   {
/* 51 */     if (properties == null) {
/* 52 */       return null;
/*    */     }
/* 54 */     Map map = new TreeMap();
/* 55 */     for (Iterator i$ = properties.keySet().iterator(); i$.hasNext(); ) { Object key = i$.next();
/*    */ 
/* 57 */       String ks = key.toString();
/* 58 */       map.put(ks, properties.getProperty(ks));
/*    */     }
/* 60 */     return map;
/*    */   }
/*    */ 
/*    */   protected void buildGraph(Map<String, String> properties)
/*    */   {
/* 70 */     this.graphFactory = new PropertiesGraphFactory(properties);
/*    */   }
/*    */ 
/*    */   public KernelDeployment build()
/*    */   {
/* 80 */     return this.graphFactory.build();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.props.DeploymentBuilder
 * JD-Core Version:    0.6.0
 */