/*     */ package org.jboss.kernel.plugins.deployment;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.MutableLifecycleHolder;
/*     */ import org.jboss.beans.metadata.spi.AnnotationMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
/*     */ import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
/*     */ import org.jboss.beans.metadata.spi.LifecycleMetaData;
/*     */ import org.jboss.beans.metadata.spi.NamedAliasMetaData;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.kernel.spi.deployment.KernelDeployment;
/*     */ import org.jboss.managed.api.annotation.ManagementObject;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ @ManagementObject
/*     */ public class AbstractKernelDeployment extends JBossObject
/*     */   implements KernelDeployment, MutableLifecycleHolder, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 2L;
/*     */   protected String name;
/*     */   protected boolean installed;
/*  68 */   protected transient List<KernelControllerContext> installedContexts = new CopyOnWriteArrayList();
/*     */   protected Boolean scoped;
/*     */   protected Set<AnnotationMetaData> annotations;
/*     */   protected List<BeanMetaDataFactory> beanFactories;
/*     */   protected ClassLoaderMetaData classLoader;
/*     */   protected LifecycleMetaData create;
/*     */   protected LifecycleMetaData start;
/*     */   protected LifecycleMetaData stop;
/*     */   protected LifecycleMetaData destroy;
/*     */   protected ControllerMode mode;
/*     */   protected Set<NamedAliasMetaData> aliases;
/*     */ 
/*     */   /** @deprecated */
/*     */   public void setBeans(List beans)
/*     */   {
/* 116 */     this.beanFactories = beans;
/* 117 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   @ManagementProperty(managed=true)
/*     */   public void setBeanFactories(List<BeanMetaDataFactory> beanFactories)
/*     */   {
/* 128 */     this.beanFactories = beanFactories;
/* 129 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 134 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 139 */     this.name = name;
/* 140 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public boolean isInstalled()
/*     */   {
/* 145 */     return this.installed;
/*     */   }
/*     */ 
/*     */   public void setInstalled(boolean installed)
/*     */   {
/* 150 */     this.installed = installed;
/* 151 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public void addInstalledContext(KernelControllerContext context)
/*     */   {
/* 156 */     this.installedContexts.add(context);
/* 157 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public List<KernelControllerContext> getInstalledContexts()
/*     */   {
/* 162 */     return this.installedContexts;
/*     */   }
/*     */ 
/*     */   public void removeInstalledContext(KernelControllerContext context)
/*     */   {
/* 167 */     this.installedContexts.remove(context);
/* 168 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public List<BeanMetaData> getBeans()
/*     */   {
/* 173 */     List factories = getBeanFactories();
/* 174 */     if ((factories == null) || (factories.size() == 0))
/* 175 */       return null;
/* 176 */     List result = new ArrayList(factories.size());
/* 177 */     for (BeanMetaDataFactory factory : factories)
/*     */     {
/* 179 */       List beans = factory.getBeans();
/* 180 */       for (BeanMetaData bmd : beans)
/*     */       {
/* 183 */         if ((this.annotations != null) && (!this.annotations.isEmpty()))
/*     */         {
/* 185 */           Set annotationsBMD = bmd.getAnnotations();
/* 186 */           if (annotationsBMD == null)
/*     */           {
/* 188 */             annotationsBMD = new HashSet();
/* 189 */             bmd.setAnnotations(annotationsBMD);
/*     */           }
/* 191 */           annotationsBMD.addAll(this.annotations);
/*     */         }
/*     */ 
/* 194 */         if ((bmd instanceof AbstractBeanMetaData))
/*     */         {
/* 196 */           AbstractBeanMetaData bean = (AbstractBeanMetaData)bmd;
/*     */ 
/* 198 */           if ((bean.getCreate() == null) && (getCreate() != null))
/*     */           {
/* 200 */             bean.setCreate(getCreate());
/*     */           }
/* 202 */           if ((bean.getStart() == null) && (getStart() != null))
/*     */           {
/* 204 */             bean.setStart(getStart());
/*     */           }
/* 206 */           if ((bean.getStop() == null) && (getStop() != null))
/*     */           {
/* 208 */             bean.setStop(getStop());
/*     */           }
/* 210 */           if ((bean.getDestroy() == null) && (getDestroy() != null))
/*     */           {
/* 212 */             bean.setDestroy(getDestroy());
/*     */           }
/*     */ 
/* 216 */           if ((bean.getMode() == null) && (getMode() != null))
/*     */           {
/* 218 */             bean.setMode(getMode());
/*     */           }
/*     */         }
/*     */       }
/* 222 */       result.addAll(beans);
/*     */     }
/* 224 */     return result;
/*     */   }
/*     */ 
/*     */   public Boolean getScoped()
/*     */   {
/* 229 */     return this.scoped;
/*     */   }
/*     */ 
/*     */   public void setScoped(Boolean scoped)
/*     */   {
/* 234 */     this.scoped = scoped;
/*     */   }
/*     */ 
/*     */   public Set<AnnotationMetaData> getAnnotations()
/*     */   {
/* 239 */     return this.annotations;
/*     */   }
/*     */ 
/*     */   public void setAnnotations(Set<AnnotationMetaData> annotations)
/*     */   {
/* 244 */     this.annotations = annotations;
/*     */   }
/*     */ 
/*     */   public List<BeanMetaDataFactory> getBeanFactories()
/*     */   {
/* 249 */     return this.beanFactories;
/*     */   }
/*     */ 
/*     */   public ClassLoaderMetaData getClassLoader()
/*     */   {
/* 254 */     return this.classLoader;
/*     */   }
/*     */ 
/*     */   public void setClassLoader(ClassLoaderMetaData classLoader)
/*     */   {
/* 264 */     this.classLoader = classLoader;
/*     */   }
/*     */ 
/*     */   public LifecycleMetaData getCreate()
/*     */   {
/* 269 */     return this.create;
/*     */   }
/*     */ 
/*     */   public void setCreate(LifecycleMetaData create)
/*     */   {
/* 274 */     create.setState(ControllerState.CREATE);
/* 275 */     this.create = create;
/*     */   }
/*     */ 
/*     */   public LifecycleMetaData getStart()
/*     */   {
/* 280 */     return this.start;
/*     */   }
/*     */ 
/*     */   public void setStart(LifecycleMetaData start)
/*     */   {
/* 285 */     start.setState(ControllerState.START);
/* 286 */     this.start = start;
/*     */   }
/*     */ 
/*     */   public LifecycleMetaData getStop()
/*     */   {
/* 291 */     return this.stop;
/*     */   }
/*     */ 
/*     */   public void setStop(LifecycleMetaData stop)
/*     */   {
/* 296 */     stop.setState(ControllerState.START);
/* 297 */     this.stop = stop;
/*     */   }
/*     */ 
/*     */   public LifecycleMetaData getDestroy()
/*     */   {
/* 302 */     return this.destroy;
/*     */   }
/*     */ 
/*     */   public void setDestroy(LifecycleMetaData destroy)
/*     */   {
/* 307 */     destroy.setState(ControllerState.CREATE);
/* 308 */     this.destroy = destroy;
/*     */   }
/*     */ 
/*     */   public Set<NamedAliasMetaData> getAliases()
/*     */   {
/* 313 */     return this.aliases;
/*     */   }
/*     */ 
/*     */   public void setAliases(Set<NamedAliasMetaData> aliases)
/*     */   {
/* 318 */     this.aliases = aliases;
/*     */   }
/*     */ 
/*     */   public ControllerMode getMode()
/*     */   {
/* 323 */     return this.mode;
/*     */   }
/*     */ 
/*     */   public void setMode(ControllerMode mode)
/*     */   {
/* 328 */     this.mode = mode;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 333 */     buffer.append("name=").append(this.name);
/* 334 */     buffer.append(" installed=").append(this.installed);
/* 335 */     if (this.classLoader != null)
/* 336 */       buffer.append(" classLoader=").append(this.classLoader);
/* 337 */     if (this.beanFactories != null)
/* 338 */       buffer.append(" beanFactories=").append(this.beanFactories);
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 343 */     buffer.append(this.name);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 349 */     in.defaultReadObject();
/* 350 */     this.installedContexts = new CopyOnWriteArrayList();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.AbstractKernelDeployment
 * JD-Core Version:    0.6.0
 */