/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import org.jboss.beans.info.plugins.BeanInfoUtil;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ class PropertyDispatchWrapper extends ExecutionWrapper
/*     */ {
/*  40 */   private static Logger log = Logger.getLogger(ConfigureAction.class);
/*     */   private PropertyMetaData property;
/*     */   private boolean nullify;
/*     */   private BeanInfo beanInfo;
/*     */   private Object target;
/*     */   private ClassLoader cl;
/*     */ 
/*     */   public PropertyDispatchWrapper(PropertyMetaData property, boolean nullify, BeanInfo beanInfo, Object target, ClassLoader cl)
/*     */   {
/*  50 */     if (property == null)
/*  51 */       throw new IllegalArgumentException("Null property");
/*  52 */     this.property = property;
/*  53 */     this.nullify = nullify;
/*  54 */     if (beanInfo == null)
/*  55 */       throw new IllegalArgumentException("Null bean info");
/*  56 */     this.beanInfo = beanInfo;
/*  57 */     if (target == null)
/*  58 */       throw new IllegalArgumentException("Null target");
/*  59 */     this.target = target;
/*  60 */     this.cl = cl;
/*     */   }
/*     */ 
/*     */   public Object execute() throws Throwable
/*     */   {
/*  65 */     String name = this.property.getName();
/*  66 */     if (this.nullify)
/*     */     {
/*     */       try
/*     */       {
/*  70 */         this.beanInfo.setProperty(this.target, name, null);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/*  74 */         if (log.isTraceEnabled())
/*  75 */           log.trace("Ignored for " + this.target + "." + name, t);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  80 */       PropertyInfo propertyInfo = BeanInfoUtil.getPropertyInfo(this.beanInfo, this.target, name);
/*  81 */       ValueMetaData valueMetaData = this.property.getValue();
/*  82 */       Object value = valueMetaData.getValue(propertyInfo.getType(), this.cl);
/*  83 */       this.beanInfo.setProperty(this.target, name, value);
/*     */     }
/*  85 */     return null;
/*     */   }
/*     */ 
/*     */   protected PrivilegedExceptionAction<Object> getAction()
/*     */   {
/*  90 */     return new PrivilegedExceptionAction()
/*     */     {
/*     */       public Object run() throws Exception
/*     */       {
/*     */         try
/*     */         {
/*  96 */           return PropertyDispatchWrapper.this.execute();
/*     */         }
/*     */         catch (RuntimeException e)
/*     */         {
/* 100 */           throw e;
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 104 */           throw e;
/*     */         }
/*     */         catch (Error e)
/*     */         {
/* 108 */           throw e;
/*     */         }
/*     */         catch (Throwable t) {
/*     */         }
/* 112 */         throw new RuntimeException(t);
/*     */       }
/*     */     };
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.PropertyDispatchWrapper
 * JD-Core Version:    0.6.0
 */