/*    */ package org.jboss.kernel.plugins.dependency;
/*    */ 
/*    */ import java.util.Set;
/*    */ import org.jboss.beans.info.spi.BeanInfo;
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.joinpoint.spi.TargettedJoinpoint;
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*    */ import org.jboss.kernel.spi.dependency.KernelController;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class OldConfigureAction extends AbstractConfigureAction
/*    */ {
/*    */   protected void installActionInternal(KernelControllerContext context)
/*    */     throws Throwable
/*    */   {
/* 44 */     KernelController controller = (KernelController)context.getController();
/* 45 */     Kernel kernel = controller.getKernel();
/* 46 */     KernelConfigurator configurator = kernel.getConfigurator();
/*    */ 
/* 48 */     Object object = context.getTarget();
/* 49 */     BeanInfo info = context.getBeanInfo();
/* 50 */     BeanMetaData metaData = context.getBeanMetaData();
/* 51 */     Set joinPoints = configurator.getPropertySetterJoinPoints(info, metaData);
/* 52 */     setAttributes(context, object, joinPoints, false);
/*    */ 
/* 54 */     installKernelControllerContextAware(context);
/*    */   }
/*    */ 
/*    */   protected void uninstallActionInternal(KernelControllerContext context)
/*    */   {
/* 59 */     uninstallKernelControllerContextAware(context);
/*    */ 
/* 61 */     KernelController controller = (KernelController)context.getController();
/* 62 */     Kernel kernel = controller.getKernel();
/* 63 */     KernelConfigurator configurator = kernel.getConfigurator();
/*    */ 
/* 65 */     Object object = context.getTarget();
/* 66 */     BeanInfo info = context.getBeanInfo();
/* 67 */     BeanMetaData metaData = context.getBeanMetaData();
/*    */     try
/*    */     {
/* 70 */       Set joinPoints = configurator.getPropertyNullerJoinPoints(info, metaData);
/* 71 */       setAttributes(context, object, joinPoints, true);
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 75 */       this.log.warn("Error unconfiguring bean " + context, t);
/*    */     }
/*    */   }
/*    */ 
/*    */   protected void setAttributes(KernelControllerContext context, Object target, Set<TargettedJoinpoint> joinPoints, boolean ignoreErrors)
/*    */     throws Throwable
/*    */   {
/*    */     boolean trace;
/* 90 */     if (!joinPoints.isEmpty())
/*    */     {
/* 92 */       trace = this.log.isTraceEnabled();
/*    */ 
/* 94 */       for (TargettedJoinpoint joinPoint : joinPoints)
/*    */       {
/* 96 */         joinPoint.setTarget(target);
/*    */         try
/*    */         {
/* 99 */           dispatchJoinPoint(context, joinPoint);
/*    */         }
/*    */         catch (Throwable t)
/*    */         {
/* 103 */           if (ignoreErrors)
/*    */           {
/* 105 */             if (trace) {
/* 106 */               this.log.trace("Ignored for " + joinPoint, t);
/*    */             }
/*    */           }
/*    */           else
/* 110 */             throw t;
/*    */         }
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.OldConfigureAction
 * JD-Core Version:    0.6.0
 */