/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.util.List;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.LifecycleMetaData;
/*     */ import org.jboss.beans.metadata.spi.ParameterMetaData;
/*     */ import org.jboss.joinpoint.spi.JoinpointException;
/*     */ import org.jboss.joinpoint.spi.MethodJoinpoint;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class LifecycleAction extends KernelControllerContextAction
/*     */ {
/*     */   protected abstract LifecycleMetaData getInstallLifecycle(BeanMetaData paramBeanMetaData);
/*     */ 
/*     */   protected abstract LifecycleMetaData getUninstallLifecycle(BeanMetaData paramBeanMetaData);
/*     */ 
/*     */   protected String getMethod(LifecycleMetaData lifecycle)
/*     */   {
/*  78 */     if (lifecycle != null)
/*  79 */       return lifecycle.getMethodName();
/*  80 */     return null;
/*     */   }
/*     */ 
/*     */   protected List<ParameterMetaData> getParameters(LifecycleMetaData lifecycle)
/*     */   {
/*  91 */     if (lifecycle != null)
/*  92 */       return lifecycle.getParameters();
/*  93 */     return null;
/*     */   }
/*     */ 
/*     */   protected String getInstallMethod(BeanMetaData beanMetaData)
/*     */   {
/* 104 */     return getMethod(getInstallLifecycle(beanMetaData));
/*     */   }
/*     */ 
/*     */   public abstract String getDefaultInstallMethod();
/*     */ 
/*     */   protected List<ParameterMetaData> getInstallParameters(BeanMetaData beanMetaData)
/*     */   {
/* 122 */     return getParameters(getInstallLifecycle(beanMetaData));
/*     */   }
/*     */ 
/*     */   protected String getUninstallMethod(BeanMetaData beanMetaData)
/*     */   {
/* 133 */     return getMethod(getUninstallLifecycle(beanMetaData));
/*     */   }
/*     */ 
/*     */   public abstract String getDefaultUninstallMethod();
/*     */ 
/*     */   protected List<ParameterMetaData> getUninstallParameters(BeanMetaData beanMetaData)
/*     */   {
/* 151 */     return getParameters(getUninstallLifecycle(beanMetaData));
/*     */   }
/*     */ 
/*     */   protected boolean isInstallInvocationIgnored(KernelControllerContext context)
/*     */   {
/* 162 */     return isInvocationIgnored(getInstallLifecycle(context.getBeanMetaData()));
/*     */   }
/*     */ 
/*     */   protected boolean isUninstallInvocationIgnored(KernelControllerContext context)
/*     */   {
/* 173 */     return isInvocationIgnored(getUninstallLifecycle(context.getBeanMetaData()));
/*     */   }
/*     */ 
/*     */   protected boolean isInvocationIgnored(LifecycleMetaData lifecycle)
/*     */   {
/* 184 */     return (lifecycle != null) && (lifecycle.isIgnored());
/*     */   }
/*     */ 
/*     */   protected void installActionInternal(KernelControllerContext context) throws Throwable
/*     */   {
/* 189 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 191 */     if (!isInstallInvocationIgnored(context)) { KernelController controller = (KernelController)context.getController();
/* 195 */       Kernel kernel = controller.getKernel();
/* 196 */       KernelConfigurator configurator = kernel.getConfigurator();
/*     */ 
/* 198 */       Object target = context.getTarget();
/* 199 */       BeanInfo info = context.getBeanInfo();
/* 200 */       BeanMetaData metaData = context.getBeanMetaData();
/* 201 */       String method = getInstallMethod(context);
/* 202 */       List parameters = getInstallParameters(context);
/*     */       MethodJoinpoint joinpoint;
/*     */       try { ClassLoader cl = Configurator.getClassLoader(metaData);
/* 207 */         joinpoint = configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
/*     */       }
/*     */       catch (JoinpointException ignored)
/*     */       {
/* 211 */         if (trace)
/*     */         {
/* 213 */           if (parameters == null)
/* 214 */             this.log.trace("No " + method + " method for " + context);
/*     */           else
/* 216 */             this.log.trace("No " + method + parameters + " method for " + context);
/*     */         }
/* 218 */         return;
/*     */       }
/* 220 */       joinpoint.setTarget(target);
/* 221 */       dispatchJoinPoint(context, joinpoint);
/*     */     }
/* 223 */     else if (trace) {
/* 224 */       this.log.trace("Ignoring " + getDefaultInstallMethod() + " lifecycle invocation.");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void uninstallActionInternal(KernelControllerContext context) {
/* 229 */     boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 231 */     if (!isUninstallInvocationIgnored(context))
/*     */     {
/* 234 */       KernelController controller = (KernelController)context.getController();
/* 235 */       Kernel kernel = controller.getKernel();
/* 236 */       KernelConfigurator configurator = kernel.getConfigurator();
/*     */ 
/* 238 */       Object target = context.getTarget();
/* 239 */       BeanInfo info = context.getBeanInfo();
/* 240 */       BeanMetaData metaData = context.getBeanMetaData();
/* 241 */       String method = getUninstallMethod(context);
/* 242 */       List parameters = getUninstallParameters(context);
/*     */       try
/*     */       {
/* 246 */         ClassLoader cl = Configurator.getClassLoader(metaData);
/* 247 */         MethodJoinpoint joinpoint = configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
/* 248 */         joinpoint.setTarget(target);
/* 249 */         dispatchJoinPoint(context, joinpoint);
/*     */       }
/*     */       catch (JoinpointException ignored)
/*     */       {
/* 253 */         if (trace)
/*     */         {
/* 255 */           if (parameters == null)
/* 256 */             this.log.trace("No " + method + " method for " + context);
/*     */           else
/* 258 */             this.log.trace("No " + method + parameters + " method for " + context);
/*     */         }
/*     */       }
/*     */       catch (Throwable throwable)
/*     */       {
/* 263 */         this.log.warn("Error during " + method + " for " + context.getName(), throwable);
/*     */       }
/*     */     }
/* 266 */     else if (trace) {
/* 267 */       this.log.trace("Ignoring " + getDefaultUninstallMethod() + " lifecycle invocation.");
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getInstallMethod(KernelControllerContext context)
/*     */   {
/* 278 */     String installMethod = getInstallMethod(context.getBeanMetaData());
/* 279 */     if (installMethod != null)
/*     */     {
/* 281 */       return installMethod;
/*     */     }
/* 283 */     return getDefaultInstallMethod();
/*     */   }
/*     */ 
/*     */   public List<ParameterMetaData> getInstallParameters(KernelControllerContext context)
/*     */   {
/* 295 */     return getInstallParameters(context.getBeanMetaData());
/*     */   }
/*     */ 
/*     */   public String getUninstallMethod(KernelControllerContext context)
/*     */   {
/* 306 */     String uninstallMethod = getUninstallMethod(context.getBeanMetaData());
/* 307 */     if (uninstallMethod != null)
/*     */     {
/* 309 */       return uninstallMethod;
/*     */     }
/* 311 */     return getDefaultUninstallMethod();
/*     */   }
/*     */ 
/*     */   public List<ParameterMetaData> getUninstallParameters(KernelControllerContext context)
/*     */   {
/* 323 */     return getUninstallParameters(context.getBeanMetaData());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.LifecycleAction
 * JD-Core Version:    0.6.0
 */