/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.beans.metadata.spi.AnnotationMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*     */ import org.jboss.dependency.plugins.AbstractScopeInfo;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
/*     */ import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
/*     */ import org.jboss.metadata.spi.scope.CommonLevels;
/*     */ import org.jboss.metadata.spi.scope.Scope;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ import org.jboss.metadata.spi.signature.MethodSignature;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ 
/*     */ public class KernelScopeInfo extends AbstractScopeInfo
/*     */ {
/*     */   private BeanMetaData beanMetaData;
/*     */ 
/*     */   public KernelScopeInfo(Object name, String className, BeanMetaData beanMetaData)
/*     */   {
/*  63 */     super(name, className);
/*  64 */     this.beanMetaData = beanMetaData;
/*     */   }
/*     */ 
/*     */   public ScopeKey getScope()
/*     */   {
/*  71 */     ScopeKey key = super.getScope();
/*  72 */     Scope scope = key.getScope(CommonLevels.CLASS);
/*  73 */     if (scope == null)
/*  74 */       return key;
/*  75 */     Object qualifier = scope.getQualifier();
/*  76 */     if ((qualifier instanceof Class)) {
/*  77 */       return key;
/*  79 */     }String className = (String)qualifier;
/*     */     ClassLoader cl;
/*     */     try {
/*  83 */       cl = Configurator.getClassLoader(this.beanMetaData);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  87 */       throw new RuntimeException("Error getting classloader for " + key, t);
/*     */     }
/*     */     Class clazz;
/*     */     try {
/*  92 */       clazz = cl.loadClass(className);
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/*  96 */       throw new RuntimeException("Unable to load class: " + className + " for " + key, e);
/*     */     }
/*  98 */     key.addScope(new Scope(CommonLevels.CLASS, clazz));
/*  99 */     return key;
/*     */   }
/*     */ 
/*     */   public void addMetaData(MutableMetaDataRepository repository, ControllerContext context, MemoryMetaDataLoader mutable)
/*     */   {
/* 105 */     if (!(context instanceof KernelControllerContext))
/* 106 */       return;
/* 107 */     KernelControllerContext theContext = (KernelControllerContext)context;
/* 108 */     addClassAnnotations(mutable, theContext);
/* 109 */     addPropertyAnnotations(mutable, theContext);
/*     */   }
/*     */ 
/*     */   private void addClassAnnotations(MemoryMetaDataLoader mutable, KernelControllerContext context)
/*     */   {
/* 120 */     BeanMetaData beanMetaData = context.getBeanMetaData();
/* 121 */     if (beanMetaData != null)
/*     */     {
/*     */       ClassLoader cl;
/*     */       try {
/* 126 */         cl = Configurator.getClassLoader(beanMetaData);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 130 */         throw new RuntimeException("Error getting classloader for " + beanMetaData.getName(), t);
/*     */       }
/* 132 */       addAnnotations(cl, mutable, beanMetaData.getAnnotations());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addPropertyAnnotations(MemoryMetaDataLoader mutable, KernelControllerContext context)
/*     */   {
/* 144 */     BeanMetaData beanMetaData = context.getBeanMetaData();
/* 145 */     if (beanMetaData == null) {
/* 146 */       return;
/*     */     }
/* 148 */     Set properties = beanMetaData.getProperties();
/*     */ 
/* 150 */     if ((properties == null) || (properties.size() == 0)) {
/* 151 */       return;
/*     */     }
/* 153 */     BeanInfo beanInfo = context.getBeanInfo();
/* 154 */     if (beanInfo == null)
/* 155 */       return;
/*     */     ClassLoader cl;
/*     */     try
/*     */     {
/* 160 */       cl = Configurator.getClassLoader(beanMetaData);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 164 */       throw new RuntimeException("Error getting classloader for metadata");
/*     */     }
/* 166 */     for (PropertyMetaData property : properties)
/* 167 */       addPropertyAnnotations(cl, mutable, property, beanInfo);
/*     */   }
/*     */ 
/*     */   private void addPropertyAnnotations(ClassLoader classloader, MemoryMetaDataLoader mutable, PropertyMetaData propertyMetaData, BeanInfo beanInfo)
/*     */   {
/* 180 */     Set propertyAnnotations = propertyMetaData.getAnnotations();
/* 181 */     if ((propertyAnnotations == null) || (propertyAnnotations.size() == 0)) {
/* 182 */       return;
/*     */     }
/* 184 */     Set propertyInfos = beanInfo.getProperties();
/* 185 */     if ((propertyInfos != null) && (propertyInfos.size() > 0))
/*     */     {
/* 187 */       for (PropertyInfo propertyInfo : propertyInfos)
/*     */       {
/* 189 */         if (propertyInfo.getName().equals(propertyMetaData.getName()))
/*     */         {
/* 191 */           MethodInfo methodInfo = propertyInfo.getGetter();
/* 192 */           if (methodInfo != null)
/* 193 */             addAnnotations(classloader, mutable, methodInfo, propertyAnnotations);
/* 194 */           methodInfo = propertyInfo.getSetter();
/* 195 */           if (methodInfo != null)
/* 196 */             addAnnotations(classloader, mutable, methodInfo, propertyAnnotations);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addAnnotations(ClassLoader classloader, MemoryMetaDataLoader mutable, MethodInfo methodInfo, Set<AnnotationMetaData> annotations)
/*     */   {
/* 212 */     ScopeKey scope = new ScopeKey(CommonLevels.JOINPOINT_OVERRIDE, methodInfo.getName());
/* 213 */     MemoryMetaDataLoader loader = new MemoryMetaDataLoader(scope);
/* 214 */     addAnnotations(classloader, loader, annotations);
/* 215 */     mutable.addComponentMetaDataRetrieval(new MethodSignature(methodInfo), loader);
/*     */   }
/*     */ 
/*     */   private void addAnnotations(ClassLoader classloader, MemoryMetaDataLoader mutable, Set<AnnotationMetaData> annotations)
/*     */   {
/* 227 */     if ((annotations == null) || (annotations.size() == 0)) {
/* 228 */       return;
/*     */     }
/* 230 */     for (AnnotationMetaData annotation : annotations)
/* 231 */       mutable.addAnnotation(annotation.getAnnotationInstance(classloader));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.KernelScopeInfo
 * JD-Core Version:    0.6.0
 */