/*    */ package org.jboss.kernel.plugins.dependency;
/*    */ 
/*    */ import java.util.Hashtable;
/*    */ import javax.naming.Context;
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.NamingException;
/*    */ import org.jboss.kernel.plugins.registry.AbstractKernelRegistryEntry;
/*    */ import org.jboss.kernel.spi.registry.KernelRegistryEntry;
/*    */ import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
/*    */ 
/*    */ public class JNDIKernelRegistryPlugin
/*    */   implements KernelRegistryPlugin
/*    */ {
/*    */   private Hashtable properties;
/*    */   private Context context;
/*    */ 
/*    */   public void setProperties(Hashtable properties)
/*    */   {
/* 45 */     this.properties = properties;
/*    */   }
/*    */ 
/*    */   public void create() throws NamingException
/*    */   {
/* 50 */     if (this.properties != null)
/* 51 */       this.context = new InitialContext(this.properties);
/*    */     else
/* 53 */       this.context = new InitialContext();
/*    */   }
/*    */ 
/*    */   public void destroy() throws NamingException
/*    */   {
/* 58 */     if (this.context != null)
/* 59 */       this.context.close();
/* 60 */     this.context = null;
/*    */   }
/*    */ 
/*    */   public KernelRegistryEntry getEntry(Object name)
/*    */   {
/*    */     try
/*    */     {
/* 67 */       Object target = this.context.lookup(name.toString());
/* 68 */       if (target != null)
/* 69 */         return new AbstractKernelRegistryEntry(name, target);
/*    */     }
/*    */     catch (NamingException e)
/*    */     {
/*    */     }
/* 74 */     return null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.JNDIKernelRegistryPlugin
 * JD-Core Version:    0.6.0
 */