/*    */ package org.jboss.kernel.plugins.dependency;
/*    */ 
/*    */ import java.util.StringTokenizer;
/*    */ import org.jboss.kernel.api.dependency.Matcher;
/*    */ import org.jboss.kernel.api.dependency.NonNullMatcherTransformer;
/*    */ 
/*    */ public class IntervalMatcherTransformer extends NonNullMatcherTransformer
/*    */ {
/*    */   protected Matcher internalTransform(Object value)
/*    */   {
/* 38 */     String interval = value.toString();
/*    */ 
/* 40 */     Number floor = null;
/* 41 */     Number ceiling = null;
/* 42 */     StringTokenizer st = new StringTokenizer(interval, ",[]()", true);
/* 43 */     Boolean floorIsGreaterThan = null;
/* 44 */     Boolean ceilingIsLessThan = null;
/* 45 */     boolean mid = false;
/* 46 */     while (st.hasMoreTokens())
/*    */     {
/* 48 */       String token = st.nextToken();
/* 49 */       if (token.equals("["))
/* 50 */         floorIsGreaterThan = Boolean.valueOf(false);
/* 51 */       else if (token.equals("("))
/* 52 */         floorIsGreaterThan = Boolean.valueOf(true);
/* 53 */       else if (token.equals("]"))
/* 54 */         ceilingIsLessThan = Boolean.valueOf(false);
/* 55 */       else if (token.equals(")"))
/* 56 */         ceilingIsLessThan = Boolean.valueOf(true);
/* 57 */       else if (token.equals(","))
/* 58 */         mid = true;
/* 59 */       else if (!token.equals("\""))
/*    */       {
/* 61 */         if (floor == null)
/* 62 */           floor = Double.valueOf(Double.parseDouble(token));
/*    */         else {
/* 64 */           ceiling = Double.valueOf(Double.parseDouble(token));
/*    */         }
/*    */       }
/*    */     }
/*    */ 
/* 69 */     if ((floorIsGreaterThan == null) || (ceilingIsLessThan == null))
/*    */     {
/* 72 */       if (mid) {
/* 73 */         throw new IllegalArgumentException("Missing parenthesis: " + interval);
/*    */       }
/* 75 */       floorIsGreaterThan = Boolean.valueOf(false);
/* 76 */       ceilingIsLessThan = Boolean.valueOf(false);
/*    */     }
/*    */ 
/* 79 */     return new IntervalMatcher(floor, ceiling, floorIsGreaterThan.booleanValue(), ceilingIsLessThan.booleanValue());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.IntervalMatcherTransformer
 * JD-Core Version:    0.6.0
 */