/*    */ package org.jboss.kernel.plugins.dependency;
/*    */ 
/*    */ import java.security.AccessControlContext;
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedActionException;
/*    */ import java.security.PrivilegedExceptionAction;
/*    */ 
/*    */ abstract class ExecutionWrapper
/*    */ {
/*    */   public Object execute(AccessControlContext access)
/*    */     throws Throwable
/*    */   {
/* 43 */     if (access == null)
/*    */     {
/* 45 */       return execute();
/*    */     }
/*    */ 
/* 49 */     PrivilegedExceptionAction action = getAction();
/*    */     try
/*    */     {
/* 52 */       return AccessController.doPrivileged(action, access);
/*    */     }
/*    */     catch (PrivilegedActionException e) {
/*    */     }
/* 56 */     throw e.getCause();
/*    */   }
/*    */ 
/*    */   protected abstract Object execute()
/*    */     throws Throwable;
/*    */ 
/*    */   protected abstract PrivilegedExceptionAction<Object> getAction();
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.ExecutionWrapper
 * JD-Core Version:    0.6.0
 */