/*    */ package org.jboss.kernel.plugins.dependency;
/*    */ 
/*    */ import java.util.List;
/*    */ import org.jboss.beans.info.spi.BeanInfo;
/*    */ import org.jboss.classadapter.spi.DependencyBuilderListItem;
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.kernel.plugins.annotations.BeanAnnotationAdapter;
/*    */ import org.jboss.kernel.plugins.annotations.BeanAnnotationAdapterFactory;
/*    */ import org.jboss.kernel.spi.dependency.KernelController;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.metadata.spi.MetaData;
/*    */ 
/*    */ public class DescribeAction extends KernelControllerContextAction
/*    */ {
/*    */   protected void installActionInternal(KernelControllerContext context)
/*    */     throws Throwable
/*    */   {
/* 46 */     BeanInfo info = context.getBeanInfo();
/* 47 */     if (info != null)
/*    */     {
/* 49 */       KernelController controller = (KernelController)context.getController();
/* 50 */       KernelMetaDataRepository repository = controller.getKernel().getMetaDataRepository();
/* 51 */       MetaData md = repository.getMetaData(context);
/*    */ 
/* 53 */       List dependencies = info.getDependencies(md);
/* 54 */       this.log.trace("Extra dependencies for " + context.getName() + " " + dependencies);
/* 55 */       if ((dependencies != null) && (!dependencies.isEmpty()))
/*    */       {
/* 57 */         for (DependencyBuilderListItem dependencyItem : dependencies)
/*    */         {
/* 59 */           dependencyItem.addDependency(context);
/*    */         }
/*    */       }
/*    */ 
/* 63 */       AnnotationMetaDataVisitor annotationsVisitor = new AnnotationMetaDataVisitor(context);
/* 64 */       annotationsVisitor.before();
/*    */       try
/*    */       {
/* 67 */         getBeanAnnotationAdapter().applyAnnotations(annotationsVisitor);
/*    */       }
/*    */       finally
/*    */       {
/* 71 */         annotationsVisitor.after();
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   protected void uninstallActionInternal(KernelControllerContext context)
/*    */   {
/* 79 */     AnnotationMetaDataVisitor annotationsVisitor = new AnnotationMetaDataVisitor(context);
/* 80 */     annotationsVisitor.before();
/*    */     try
/*    */     {
/* 83 */       getBeanAnnotationAdapter().cleanAnnotations(annotationsVisitor);
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 87 */       this.log.debug("Error while cleaning the annotations: " + t);
/*    */     }
/*    */     finally
/*    */     {
/* 91 */       annotationsVisitor.after();
/*    */     }
/*    */   }
/*    */ 
/*    */   protected BeanAnnotationAdapter getBeanAnnotationAdapter()
/*    */   {
/* 97 */     BeanAnnotationAdapterFactory factory = BeanAnnotationAdapterFactory.getInstance();
/* 98 */     return factory.getBeanAnnotationAdapter();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.DescribeAction
 * JD-Core Version:    0.6.0
 */