/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.kernel.api.dependency.Matcher;
/*     */ import org.jboss.kernel.api.dependency.MatcherFactory;
/*     */ import org.jboss.kernel.api.dependency.MatcherTransformer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.plugins.introspection.ReflectionUtils;
/*     */ 
/*     */ public class DefaultMatcherFactory extends MatcherFactory
/*     */   implements MatcherTransformer
/*     */ {
/*  41 */   protected Logger log = Logger.getLogger(getClass());
/*     */ 
/*  44 */   private Map<String, MatcherTransformer> transfomers = new HashMap();
/*     */ 
/*     */   public DefaultMatcherFactory()
/*     */   {
/*  48 */     addMatcherTransfomer("default", this);
/*  49 */     addMatcherTransfomer("regexp", new RegexpMatcherTransformer());
/*  50 */     addMatcherTransfomer("interval", new IntervalMatcherTransformer());
/*     */   }
/*     */ 
/*     */   public void addMatcherTransfomer(String key, MatcherTransformer transformer)
/*     */   {
/*  55 */     if ((key == null) && (transformer != null)) {
/*  56 */       this.transfomers.put(transformer.getClass().getName(), transformer);
/*     */     }
/*  58 */     if (key != null)
/*     */     {
/*  60 */       if (transformer == null)
/*  61 */         this.transfomers.remove(key);
/*     */       else
/*  63 */         this.transfomers.put(key, transformer);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Matcher createMatcher(String transformer, Object value)
/*     */   {
/*  76 */     if ((value instanceof Matcher)) {
/*  77 */       return (Matcher)value;
/*     */     }
/*  79 */     if (transformer == null) {
/*  80 */       transformer = "default";
/*     */     }
/*  82 */     MatcherTransformer mt = (MatcherTransformer)this.transfomers.get(transformer);
/*  83 */     if (mt != null) {
/*  84 */       return mt.transform(value);
/*     */     }
/*  86 */     if (this.log.isTraceEnabled()) {
/*  87 */       this.log.trace("No matching transfomer key '" + transformer + "', trying to instantiate new.");
/*     */     }
/*     */     try
/*     */     {
/*  91 */       mt = (MatcherTransformer)ReflectionUtils.newInstance(transformer);
/*  92 */       return mt.transform(value);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/*  96 */     throw new IllegalArgumentException("Cannot create Matcher instance: " + t);
/*     */   }
/*     */ 
/*     */   public Matcher transform(Object value)
/*     */   {
/* 102 */     return new DefaultMatcher(value);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.DefaultMatcherFactory
 * JD-Core Version:    0.6.0
 */