/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ConfigureAction extends AbstractConfigureAction
/*     */ {
/*     */   protected void installActionInternal(KernelControllerContext context)
/*     */     throws Throwable
/*     */   {
/*  42 */     Object object = context.getTarget();
/*  43 */     BeanInfo info = context.getBeanInfo();
/*  44 */     BeanMetaData metaData = context.getBeanMetaData();
/*  45 */     setAttributes(context, object, info, metaData, false);
/*     */ 
/*  47 */     installKernelControllerContextAware(context);
/*     */   }
/*     */ 
/*     */   protected void uninstallActionInternal(KernelControllerContext context)
/*     */   {
/*  52 */     uninstallKernelControllerContextAware(context);
/*     */ 
/*  54 */     Object object = context.getTarget();
/*  55 */     BeanInfo info = context.getBeanInfo();
/*  56 */     BeanMetaData metaData = context.getBeanMetaData();
/*     */     try
/*     */     {
/*  59 */       setAttributes(context, object, info, metaData, true);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*  63 */       this.log.warn("Error unconfiguring bean " + context, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void setAttributes(KernelControllerContext context, Object target, BeanInfo info, BeanMetaData metaData, boolean nullify)
/*     */     throws Throwable
/*     */   {
/*  79 */     Set propertys = metaData.getProperties();
/*     */     ClassLoader cl;
/*  80 */     if ((propertys != null) && (!propertys.isEmpty()))
/*     */     {
/*  82 */       cl = null;
/*  83 */       if (!nullify) {
/*  84 */         cl = Configurator.getClassLoader(metaData);
/*     */       }
/*  86 */       for (PropertyMetaData property : propertys)
/*     */       {
/*  88 */         dispatchSetProperty(context, property, nullify, info, target, cl);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void dispatchSetProperty(KernelControllerContext context, PropertyMetaData property, boolean nullify, BeanInfo info, Object target, ClassLoader cl)
/*     */     throws Throwable
/*     */   {
/* 107 */     ExecutionWrapper wrapper = new PropertyDispatchWrapper(property, nullify, info, target, cl);
/* 108 */     dispatchExecutionWrapper(context, wrapper);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.ConfigureAction
 * JD-Core Version:    0.6.0
 */