/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Set;
/*     */ import org.jboss.dependency.plugins.OwnerCallbackItem;
/*     */ import org.jboss.dependency.spi.Cardinality;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public abstract class CollectionCallbackItem<T extends Collection<Object>> extends OwnerCallbackItem<Class, InvokeDispatchContext>
/*     */ {
/*     */   protected Cardinality cardinality;
/*     */   protected AttributeInfo attribute;
/*     */ 
/*     */   public CollectionCallbackItem(Class name, InvokeDispatchContext owner, AttributeInfo attribute)
/*     */   {
/*  50 */     this(name, null, null, null, owner, attribute);
/*     */   }
/*     */ 
/*     */   public CollectionCallbackItem(Class name, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality, InvokeDispatchContext context, AttributeInfo attribute)
/*     */   {
/*  55 */     super(name, whenRequired, dependentState, attribute != null ? attribute.getName() : null, context);
/*  56 */     this.attribute = attribute;
/*  57 */     this.cardinality = cardinality;
/*     */   }
/*     */ 
/*     */   protected abstract T getCollectionParameterHolder();
/*     */ 
/*     */   protected T fillHolder(Controller controller)
/*     */     throws Throwable
/*     */   {
/*  76 */     if ((controller instanceof KernelController))
/*     */     {
/*  78 */       Collection holder = getCollectionParameterHolder();
/*  79 */       if (holder == null) {
/*  80 */         throw new IllegalArgumentException("Illegal collection holder, equals null!");
/*     */       }
/*  82 */       KernelController kernelController = (KernelController)controller;
/*  83 */       Set contexts = kernelController.getContexts((Class)getIDependOn(), this.dependentState);
/*  84 */       if ((contexts != null) && (!contexts.isEmpty()))
/*     */       {
/*  86 */         for (ControllerContext context : contexts)
/*     */         {
/*  88 */           holder.add(context.getTarget());
/*     */         }
/*     */       }
/*  91 */       return holder;
/*     */     }
/*     */ 
/*  94 */     throw new IllegalArgumentException("Cannot execute Collection call back - controller not KernelController instance.");
/*     */   }
/*     */ 
/*     */   protected void execute(T holder) throws Throwable
/*     */   {
/*  99 */     if (this.attribute.isProperty())
/* 100 */       ((InvokeDispatchContext)this.owner).set(getAttributeName(), holder);
/*     */     else
/* 102 */       ((InvokeDispatchContext)this.owner).invoke(getAttributeName(), new Object[] { holder }, new String[] { this.attribute.getType().getName() });
/*     */   }
/*     */ 
/*     */   protected DependencyItem createDependencyItem(ControllerContext owner)
/*     */   {
/* 107 */     if (this.cardinality != null) {
/* 108 */       return new CallbackDependencyItem(owner.getName(), (Class)getIDependOn(), this.whenRequired, this.dependentState, this.cardinality);
/*     */     }
/* 110 */     return null;
/*     */   }
/*     */ 
/*     */   public void ownerCallback(Controller controller, boolean isInstallPhase)
/*     */     throws Throwable
/*     */   {
/* 116 */     Collection holder = isInstallPhase ? fillHolder(controller) : getCollectionParameterHolder();
/* 117 */     execute(holder);
/*     */   }
/*     */ 
/*     */   public void changeCallback(Controller controller, ControllerContext context, boolean isInstallPhase) throws Throwable
/*     */   {
/* 122 */     Collection holder = fillHolder(controller);
/* 123 */     if (!isInstallPhase)
/* 124 */       removeUninstallingContext(holder, context);
/* 125 */     execute(holder);
/* 126 */     addDependency(controller, context, isInstallPhase);
/*     */   }
/*     */ 
/*     */   protected void removeUninstallingContext(T holder, ControllerContext context)
/*     */   {
/* 141 */     holder.remove(context.getTarget());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.CollectionCallbackItem
 * JD-Core Version:    0.6.0
 */