/*    */ package org.jboss.kernel.plugins.dependency;
/*    */ 
/*    */ import java.util.Set;
/*    */ import org.jboss.dependency.plugins.SingleCallbackItem;
/*    */ import org.jboss.dependency.spi.Cardinality;
/*    */ import org.jboss.dependency.spi.Controller;
/*    */ import org.jboss.dependency.spi.ControllerContext;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.dependency.spi.DependencyItem;
/*    */ import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
/*    */ import org.jboss.kernel.spi.dependency.KernelController;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class ClassSingleCallbackItem extends SingleCallbackItem<Class>
/*    */ {
/*    */   protected Cardinality cardinality;
/*    */ 
/*    */   public ClassSingleCallbackItem(Class name, InvokeDispatchContext owner, String method)
/*    */   {
/* 47 */     super(name, owner, method);
/*    */   }
/*    */ 
/*    */   public ClassSingleCallbackItem(Class name, InvokeDispatchContext owner, String method, String signature)
/*    */   {
/* 52 */     super(name, owner, method, signature);
/*    */   }
/*    */ 
/*    */   public ClassSingleCallbackItem(Class name, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality, InvokeDispatchContext owner, String method)
/*    */   {
/* 57 */     super(name, whenRequired, dependentState, owner, method);
/*    */   }
/*    */ 
/*    */   public ClassSingleCallbackItem(Class name, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality, InvokeDispatchContext owner, String method, String signature)
/*    */   {
/* 62 */     super(name, whenRequired, dependentState, owner, method, signature);
/* 63 */     this.cardinality = cardinality;
/*    */   }
/*    */ 
/*    */   public void ownerCallback(Controller controller, boolean isInstallPhase) throws Throwable
/*    */   {
/* 68 */     if ((controller instanceof KernelController))
/*    */     {
/* 70 */       KernelController kc = (KernelController)controller;
/* 71 */       Set contexts = kc.getContexts((Class)getIDependOn(), getDependentState());
/* 72 */       if ((contexts != null) && (!contexts.isEmpty()))
/*    */       {
/* 74 */         for (KernelControllerContext context : contexts)
/*    */         {
/* 76 */           Object target = context.getTarget();
/* 77 */           if (this.signature == null)
/* 78 */             this.signature = target.getClass().getName();
/* 79 */           ((InvokeDispatchContext)this.owner).invoke(getAttributeName(), new Object[] { target }, new String[] { this.signature });
/*    */         }
/*    */       }
/*    */     }
/*    */     else {
/* 84 */       this.log.info("Controller not KernelController instance, cannot execute owner callback.");
/*    */     }
/*    */   }
/*    */ 
/*    */   protected DependencyItem createDependencyItem(ControllerContext owner) {
/* 89 */     if (this.cardinality != null) {
/* 90 */       return new CallbackDependencyItem(owner.getName(), (Class)getIDependOn(), this.whenRequired, this.dependentState, this.cardinality);
/*    */     }
/* 92 */     return null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.ClassSingleCallbackItem
 * JD-Core Version:    0.6.0
 */