/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.util.Set;
/*     */ import org.jboss.dependency.spi.Cardinality;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.util.HashCode;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class CallbackDependencyItem extends ClassDependencyItem
/*     */ {
/*     */   private Cardinality cardinality;
/*     */ 
/*     */   public CallbackDependencyItem(Object name, Class<?> demandClass, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality)
/*     */   {
/*  45 */     super(name, demandClass, whenRequired, dependentState);
/*  46 */     if (cardinality == null)
/*  47 */       throw new IllegalArgumentException("Null cardinality.");
/*  48 */     this.cardinality = cardinality;
/*     */   }
/*     */ 
/*     */   public Cardinality getCardinality()
/*     */   {
/*  53 */     return this.cardinality;
/*     */   }
/*     */ 
/*     */   protected Set<KernelControllerContext> getContexts(Controller controller)
/*     */   {
/*  58 */     if (!(controller instanceof KernelController)) {
/*  59 */       throw new IllegalArgumentException("Controller not KernelController!");
/*     */     }
/*  61 */     KernelController kernelController = (KernelController)controller;
/*  62 */     return kernelController.getContexts(getDemandClass(), getDependentState());
/*     */   }
/*     */ 
/*     */   public boolean resolve(Controller controller)
/*     */   {
/*  67 */     Set contexts = getContexts(controller);
/*  68 */     int size = contexts != null ? contexts.size() : 0;
/*  69 */     if (this.cardinality.isInRange(size))
/*     */     {
/*  71 */       setIDependOn(getIDependOn());
/*  72 */       if (contexts != null)
/*     */       {
/*  74 */         for (KernelControllerContext context : contexts)
/*  75 */           addDependsOnMe(controller, context);
/*     */       }
/*  77 */       setResolved(true);
/*     */     }
/*     */     else
/*     */     {
/*  81 */       setResolved(false);
/*     */     }
/*  83 */     return isResolved();
/*     */   }
/*     */ 
/*     */   public boolean unresolved(Controller controller)
/*     */   {
/*  88 */     if (getIDependOn() == null) {
/*  89 */       return true;
/*     */     }
/*  91 */     Set contexts = getContexts(controller);
/*     */ 
/*  93 */     int size = contexts != null ? contexts.size() - 1 : 0;
/*  94 */     return !this.cardinality.isInRange(size);
/*     */   }
/*     */ 
/*     */   protected int getHashCode()
/*     */   {
/*  99 */     int result = HashCode.generate(getName());
/* 100 */     result += 3 * HashCode.generate(getIDependOn());
/* 101 */     result += 7 * HashCode.generate(getWhenRequired());
/* 102 */     result += 11 * HashCode.generate(getDependentState());
/* 103 */     result += 19 * HashCode.generate(getCardinality());
/* 104 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 109 */     if (!(obj instanceof CallbackDependencyItem)) {
/* 110 */       return false;
/*     */     }
/* 112 */     CallbackDependencyItem cdi = (CallbackDependencyItem)obj;
/* 113 */     if (isDifferent(getName(), cdi.getName()))
/* 114 */       return false;
/* 115 */     if (isDifferent(getIDependOn(), cdi.getIDependOn()))
/* 116 */       return false;
/* 117 */     if (isDifferent(getWhenRequired(), cdi.getWhenRequired()))
/* 118 */       return false;
/* 119 */     if (isDifferent(getDependentState(), cdi.getDependentState())) {
/* 120 */       return false;
/*     */     }
/* 122 */     return !isDifferent(getCardinality(), cdi.getCardinality());
/*     */   }
/*     */ 
/*     */   protected static boolean isDifferent(Object first, Object second)
/*     */   {
/* 128 */     if (first == null) {
/* 129 */       return second != null;
/*     */     }
/* 131 */     return !first.equals(second);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 136 */     super.toString(buffer);
/* 137 */     buffer.append(" cardinality=" + this.cardinality);
/*     */   }
/*     */ 
/*     */   public String toHumanReadableString()
/*     */   {
/* 144 */     return super.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.CallbackDependencyItem
 * JD-Core Version:    0.6.0
 */