/*    */ package org.jboss.kernel.plugins.dependency;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.Collection;
/*    */ import java.util.HashSet;
/*    */ import java.util.LinkedList;
/*    */ import org.jboss.dependency.spi.Cardinality;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
/*    */ 
/*    */ public class BasicCollectionCallbackItemFactory
/*    */   implements CollectionCallbackItemFactory
/*    */ {
/*    */   public CollectionCallbackItem createCollectionCallbackItem(Class<? extends Collection> parameterClass, Class name, InvokeDispatchContext context, AttributeInfo attribute)
/*    */   {
/* 46 */     return createCollectionCallbackItem(parameterClass, name, null, null, null, context, attribute);
/*    */   }
/*    */ 
/*    */   public CollectionCallbackItem createCollectionCallbackItem(Class<? extends Collection> parameterClass, Class name, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality, InvokeDispatchContext context, AttributeInfo attribute)
/*    */   {
/* 58 */     if (parameterClass == null) {
/* 59 */       throw new IllegalArgumentException("Null parameter class!");
/*    */     }
/* 61 */     if (parameterClass.isAssignableFrom(ArrayList.class))
/* 62 */       return new ListCallbackItem(name, whenRequired, dependentState, cardinality, context, attribute);
/* 63 */     if (parameterClass.isAssignableFrom(HashSet.class))
/* 64 */       return new SetCallbackItem(name, whenRequired, dependentState, cardinality, context, attribute);
/* 65 */     if (parameterClass.isAssignableFrom(LinkedList.class)) {
/* 66 */       return new QueueCallbackItem(name, whenRequired, dependentState, cardinality, context, attribute);
/*    */     }
/* 68 */     return handleAdditionalCollectionClass(parameterClass, name, whenRequired, dependentState, cardinality, context, attribute);
/*    */   }
/*    */ 
/*    */   protected CollectionCallbackItem handleAdditionalCollectionClass(Class<? extends Collection> parameterClass, Class name, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality, InvokeDispatchContext context, AttributeInfo attribute)
/*    */   {
/* 93 */     throw new IllegalArgumentException("No matching callback impl for parameter type: " + parameterClass);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.BasicCollectionCallbackItemFactory
 * JD-Core Version:    0.6.0
 */