/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.Stack;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.dependency.spi.CallbackItem;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class AbstractMetaDataVisitor
/*     */   implements MetaDataVisitor
/*     */ {
/*  46 */   private static final Logger log = Logger.getLogger(AbstractMetaDataVisitor.class);
/*     */ 
/*  49 */   protected ControllerState contextState = ControllerState.INSTANTIATED;
/*     */   protected BeanMetaData bmd;
/*     */   protected KernelControllerContext context;
/*     */   protected Stack<MetaDataVisitorNode> visitorNodeStack;
/*     */ 
/*     */   protected AbstractMetaDataVisitor(BeanMetaData bmd, KernelControllerContext context)
/*     */   {
/*  64 */     this.bmd = bmd;
/*  65 */     this.context = context;
/*  66 */     this.visitorNodeStack = new Stack();
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitorNode node)
/*     */   {
/*  71 */     this.visitorNodeStack.push(node);
/*     */     try
/*     */     {
/*  74 */       internalInitialVisit(node);
/*     */     }
/*     */     finally
/*     */     {
/*  78 */       this.visitorNodeStack.pop();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void describeVisit(MetaDataVisitorNode node)
/*     */   {
/*  84 */     this.visitorNodeStack.push(node);
/*     */     try
/*     */     {
/*  87 */       internalDescribeVisit(node);
/*     */     }
/*     */     finally
/*     */     {
/*  91 */       this.visitorNodeStack.pop();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void internalInitialVisit(MetaDataVisitorNode node)
/*     */   {
/*  97 */     boolean trace = log.isTraceEnabled();
/*  98 */     if (trace) {
/*  99 */       log.trace("Initial visit node " + node);
/*     */     }
/*     */ 
/* 102 */     Iterator children = node.getChildren();
/* 103 */     if (children != null)
/*     */     {
/* 105 */       ControllerState restoreState = this.contextState;
/* 106 */       while (children.hasNext())
/*     */       {
/* 108 */         MetaDataVisitorNode child = (MetaDataVisitorNode)children.next();
/*     */         try
/*     */         {
/* 111 */           child.initialVisit(this);
/*     */         }
/*     */         finally
/*     */         {
/* 115 */           this.contextState = restoreState;
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void internalDescribeVisit(MetaDataVisitorNode node)
/*     */   {
/* 123 */     boolean trace = log.isTraceEnabled();
/* 124 */     if (trace) {
/* 125 */       log.trace("Describe visit node " + node);
/*     */     }
/*     */ 
/* 128 */     Iterator children = node.getChildren();
/* 129 */     if (children != null)
/*     */     {
/* 131 */       ControllerState restoreState = this.contextState;
/* 132 */       while (children.hasNext())
/*     */       {
/* 134 */         MetaDataVisitorNode child = (MetaDataVisitorNode)children.next();
/*     */         try
/*     */         {
/* 137 */           child.describeVisit(this);
/*     */         }
/*     */         finally
/*     */         {
/* 141 */           this.contextState = restoreState;
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public KernelControllerContext getControllerContext()
/*     */   {
/* 149 */     return this.context;
/*     */   }
/*     */ 
/*     */   public ControllerState getContextState()
/*     */   {
/* 154 */     return this.contextState;
/*     */   }
/*     */ 
/*     */   public DependencyInfo getDependencyInfo()
/*     */   {
/* 159 */     return this.context.getDependencyInfo();
/*     */   }
/*     */ 
/*     */   public void addDependency(DependencyItem dependency)
/*     */   {
/* 164 */     getDependencyInfo().addIDependOn(dependency);
/*     */   }
/*     */ 
/*     */   public <T> void addInstallCallback(CallbackItem<T> callback)
/*     */   {
/* 169 */     getDependencyInfo().addInstallItem(callback);
/*     */   }
/*     */ 
/*     */   public <T> void addUninstallCallback(CallbackItem<T> callback)
/*     */   {
/* 174 */     getDependencyInfo().addUninstallItem(callback);
/*     */   }
/*     */ 
/*     */   public void setContextState(ControllerState contextState)
/*     */   {
/* 179 */     this.contextState = contextState;
/*     */   }
/*     */ 
/*     */   public Stack<MetaDataVisitorNode> visitorNodeStack()
/*     */   {
/* 184 */     return this.visitorNodeStack;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.AbstractMetaDataVisitor
 * JD-Core Version:    0.6.0
 */