/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.security.AccessControlContext;
/*     */ import java.security.AccessController;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.dependency.plugins.AbstractControllerContext;
/*     */ import org.jboss.dependency.plugins.AbstractDependencyInfo;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerMode;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import sun.security.util.SecurityConstants;
/*     */ 
/*     */ public class AbstractKernelControllerContext extends AbstractControllerContext
/*     */   implements KernelControllerContext
/*     */ {
/*  52 */   private static final KernelControllerContextActions actions = KernelControllerContextActions.getInstance();
/*     */ 
/*  55 */   private static final KernelControllerContextActions noInstantiate = KernelControllerContextActions.getNoInstantiate();
/*     */   protected BeanInfo info;
/*     */   protected BeanMetaData metaData;
/*     */   protected AccessControlContext accessContext;
/*     */   protected boolean isInitialProcessed;
/*     */   protected boolean isDescribeProcessed;
/*     */ 
/*     */   public AbstractKernelControllerContext(BeanInfo info, BeanMetaData metaData, Object target)
/*     */   {
/*  81 */     super(metaData.getName(), metaData.getAliases(), target == null ? actions : noInstantiate, new AbstractDependencyInfo(), target);
/*  82 */     this.info = info;
/*  83 */     this.metaData = metaData;
/*  84 */     ControllerMode mode = metaData.getMode();
/*  85 */     if (mode != null)
/*  86 */       setMode(mode);
/*  87 */     boolean autowireCandidate = metaData.isAutowireCandidate();
/*  88 */     getDependencyInfo().setAutowireCandidate(autowireCandidate);
/*  89 */     if (System.getSecurityManager() != null)
/*  90 */       this.accessContext = AccessController.getContext();
/*  91 */     initKernelScopeInfo();
/*     */   }
/*     */ 
/*     */   public Kernel getKernel()
/*     */   {
/*  96 */     KernelController controller = (KernelController)getController();
/*  97 */     if (controller == null)
/*  98 */       throw new IllegalStateException("Context is not installed in controller");
/*  99 */     return controller.getKernel();
/*     */   }
/*     */ 
/*     */   public BeanInfo getBeanInfo()
/*     */   {
/* 104 */     return this.info;
/*     */   }
/*     */ 
/*     */   public void setBeanInfo(BeanInfo info)
/*     */   {
/* 114 */     this.info = info;
/* 115 */     infoprocessMetaData();
/* 116 */     flushJBossObjectCache();
/*     */   }
/*     */ 
/*     */   public BeanMetaData getBeanMetaData()
/*     */   {
/* 121 */     return this.metaData;
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 126 */     if (this.metaData != null)
/* 127 */       buffer.append(" metadata=").append(this.metaData);
/* 128 */     super.toString(buffer);
/*     */   }
/*     */ 
/*     */   public void setController(Controller controller)
/*     */   {
/* 133 */     super.setController(controller);
/* 134 */     preprocessMetaData();
/*     */   }
/*     */ 
/*     */   protected void initScopeInfo()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void initKernelScopeInfo()
/*     */   {
/* 145 */     String className = null;
/* 146 */     Object target = getTarget();
/* 147 */     if (target != null)
/* 148 */       className = target.getClass().getName();
/* 149 */     BeanMetaData bmd = getBeanMetaData();
/* 150 */     if (bmd != null)
/*     */     {
/* 152 */       String bean = bmd.getBean();
/* 153 */       if (bean != null)
/* 154 */         className = bean;
/*     */     }
/* 156 */     setScopeInfo(new KernelScopeInfo(getName(), className, bmd));
/*     */   }
/*     */ 
/*     */   protected void preprocessMetaData()
/*     */   {
/* 164 */     if (this.metaData == null)
/* 165 */       return;
/* 166 */     if (this.isInitialProcessed) return;
/* 167 */     PreprocessMetaDataVisitor visitor = new PreprocessMetaDataVisitor(this.metaData, this);
/* 168 */     AccessController.doPrivileged(visitor);
/* 169 */     this.isInitialProcessed = true;
/*     */   }
/*     */ 
/*     */   protected void infoprocessMetaData()
/*     */   {
/* 177 */     if (this.info == null)
/*     */     {
/* 179 */       removeClassContextReference();
/* 180 */       return;
/*     */     }
/* 182 */     if (this.isDescribeProcessed) return;
/* 183 */     DescribedMetaDataVisitor visitor = new DescribedMetaDataVisitor(this.metaData, this);
/* 184 */     AccessController.doPrivileged(visitor);
/* 185 */     this.isDescribeProcessed = true;
/*     */   }
/*     */ 
/*     */   protected AccessControlContext getAccessControlContext()
/*     */   {
/* 197 */     return this.accessContext;
/*     */   }
/*     */ 
/*     */   private void removeClassContextReference()
/*     */   {
/* 202 */     DependencyInfo dependencyInfo = getDependencyInfo();
/* 203 */     if (dependencyInfo != null)
/*     */     {
/* 206 */       Set dependencys = dependencyInfo.getIDependOn(ClassContextDependencyItem.class);
/* 207 */       dependencys.addAll(dependencyInfo.getIDependOn(CallbackDependencyItem.class));
/* 208 */       for (DependencyItem di : dependencys)
/*     */       {
/* 211 */         ClassDependencyItem cdi = (ClassDependencyItem)di;
/* 212 */         cdi.clear(getController());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected BeanInfo getInfo()
/*     */   {
/* 219 */     if (this.info == null)
/* 220 */       throw new IllegalArgumentException("Null BeanInfo");
/* 221 */     return this.info;
/*     */   }
/*     */ 
/*     */   public Object get(String name) throws Throwable
/*     */   {
/* 226 */     return getInfo().getProperty(getTarget(), name);
/*     */   }
/*     */ 
/*     */   public void set(String name, Object value) throws Throwable
/*     */   {
/* 231 */     getInfo().setProperty(getTarget(), name, value);
/*     */   }
/*     */ 
/*     */   public Object invoke(String name, Object[] parameters, String[] signature) throws Throwable
/*     */   {
/* 236 */     return getInfo().invoke(getTarget(), name, signature, parameters);
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassLoader()
/*     */     throws Throwable
/*     */   {
/* 242 */     SecurityManager sm = System.getSecurityManager();
/* 243 */     if (sm != null)
/* 244 */       sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
/* 245 */     return Configurator.getClassLoader(getBeanMetaData());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext
 * JD-Core Version:    0.6.0
 */