/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import java.util.concurrent.CopyOnWriteArrayList;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.SupplyMetaData;
/*     */ import org.jboss.dependency.plugins.ScopedController;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.api.dependency.Matcher;
/*     */ import org.jboss.kernel.plugins.event.AbstractEventEmitter;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.kernel.spi.event.KernelEvent;
/*     */ import org.jboss.kernel.spi.event.KernelEventFilter;
/*     */ import org.jboss.kernel.spi.event.KernelEventListener;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistry;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryEntry;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class AbstractKernelController extends ScopedController
/*     */   implements KernelController, KernelRegistryPlugin
/*     */ {
/*     */   protected Kernel kernel;
/*  61 */   protected AbstractEventEmitter emitterDelegate = createEventEmitter();
/*     */ 
/*  64 */   protected Map<Object, List<KernelControllerContext>> suppliers = new ConcurrentHashMap();
/*     */ 
/*  67 */   protected Map<Class<?>, ClassContext> contextsByClass = new ConcurrentHashMap();
/*     */ 
/*     */   public AbstractKernelController()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   protected AbstractEventEmitter createEventEmitter()
/*     */   {
/*  85 */     return new AbstractEventEmitter();
/*     */   }
/*     */ 
/*     */   public KernelControllerContext install(BeanMetaData metaData) throws Throwable
/*     */   {
/*  90 */     return install(metaData, null);
/*     */   }
/*     */ 
/*     */   public KernelControllerContext install(BeanMetaData metaData, Object target) throws Throwable
/*     */   {
/*  95 */     KernelControllerContext context = new AbstractKernelControllerContext(null, metaData, target);
/*  96 */     install(context);
/*  97 */     return context;
/*     */   }
/*     */ 
/*     */   public KernelRegistryEntry getEntry(Object name)
/*     */   {
/*     */     List list;
/*     */     List list;
/* 103 */     if ((name instanceof Matcher))
/* 104 */       list = matchSupplies((Matcher)name);
/*     */     else
/* 106 */       list = (List)this.suppliers.get(name);
/* 107 */     if ((list != null) && (!list.isEmpty()))
/* 108 */       return (KernelRegistryEntry)list.get(0);
/* 109 */     if ((name instanceof Class)) {
/* 110 */       return getContextByClass((Class)name);
/*     */     }
/* 112 */     return null;
/*     */   }
/*     */ 
/*     */   protected List<KernelControllerContext> matchSupplies(Matcher matcher)
/*     */   {
/* 123 */     for (Map.Entry entry : this.suppliers.entrySet())
/*     */     {
/* 125 */       if (matcher.match(entry.getKey()))
/* 126 */         return (List)entry.getValue();
/*     */     }
/* 128 */     return null;
/*     */   }
/*     */ 
/*     */   public ControllerContext getContext(Object name, ControllerState state)
/*     */   {
/* 133 */     ControllerContext context = super.getContext(name, state);
/* 134 */     if (context != null)
/* 135 */       return context;
/* 136 */     if ((state == null) || (ControllerState.INSTALLED.equals(state)))
/*     */     {
/* 138 */       KernelRegistry registry = this.kernel.getRegistry();
/*     */       try
/*     */       {
/* 141 */         return registry.getEntry(name);
/*     */       }
/*     */       catch (Throwable ignored)
/*     */       {
/*     */       }
/*     */     }
/* 147 */     return null;
/*     */   }
/*     */ 
/*     */   public void addSupplies(KernelControllerContext context)
/*     */   {
/* 152 */     BeanMetaData metaData = context.getBeanMetaData();
/* 153 */     Set supplies = metaData.getSupplies();
/* 154 */     if (supplies != null)
/*     */     {
/* 156 */       boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 158 */       if (!supplies.isEmpty())
/*     */       {
/* 160 */         lockWrite();
/*     */         try
/*     */         {
/* 163 */           for (SupplyMetaData supplied : supplies)
/*     */           {
/* 165 */             Object supply = supplied.getSupply();
/* 166 */             List list = (List)this.suppliers.get(supply);
/* 167 */             if (list == null)
/*     */             {
/* 169 */               list = new CopyOnWriteArrayList();
/* 170 */               this.suppliers.put(supply, list);
/*     */             }
/* 172 */             list.add(context);
/* 173 */             if (trace)
/* 174 */               this.log.trace("Suppliers of " + supply + ": " + list);
/*     */           }
/*     */         }
/*     */         finally
/*     */         {
/* 179 */           unlockWrite();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeSupplies(KernelControllerContext context)
/*     */   {
/* 187 */     BeanMetaData metaData = context.getBeanMetaData();
/* 188 */     Set supplies = metaData.getSupplies();
/* 189 */     if (supplies != null)
/*     */     {
/* 191 */       boolean trace = this.log.isTraceEnabled();
/*     */ 
/* 193 */       if (!supplies.isEmpty())
/*     */       {
/* 195 */         lockWrite();
/*     */         try
/*     */         {
/* 198 */           for (SupplyMetaData supplied : supplies)
/*     */           {
/* 200 */             Object supply = supplied.getSupply();
/* 201 */             List list = (List)this.suppliers.get(supply);
/* 202 */             if (list != null)
/*     */             {
/* 204 */               list.remove(context);
/* 205 */               if (list.isEmpty())
/* 206 */                 this.suppliers.remove(supply);
/* 207 */               if (trace)
/* 208 */                 this.log.trace("Suppliers of " + supply + ": " + list);
/*     */             }
/*     */           }
/*     */         }
/*     */         finally
/*     */         {
/* 214 */           unlockWrite();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Kernel getKernel()
/*     */   {
/* 222 */     Kernel.checkAccess();
/* 223 */     return this.kernel;
/*     */   }
/*     */ 
/*     */   public void setKernel(Kernel kernel) throws Throwable
/*     */   {
/* 228 */     Kernel.checkConfigure();
/* 229 */     this.kernel = kernel;
/*     */   }
/*     */ 
/*     */   public void fireKernelEvent(KernelEvent event)
/*     */   {
/* 234 */     this.emitterDelegate.fireKernelEvent(event);
/*     */   }
/*     */ 
/*     */   public void registerListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable
/*     */   {
/* 239 */     this.emitterDelegate.registerListener(listener, filter, handback);
/*     */   }
/*     */ 
/*     */   public void unregisterListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable
/*     */   {
/* 244 */     this.emitterDelegate.unregisterListener(listener, filter, handback);
/*     */   }
/*     */ 
/*     */   protected Set<KernelControllerContext> getContexts(Class<?> clazz)
/*     */   {
/* 256 */     ClassContext classContext = (ClassContext)this.contextsByClass.get(clazz);
/* 257 */     if (classContext != null)
/*     */     {
/* 259 */       if (this.log.isTraceEnabled())
/*     */       {
/* 261 */         this.log.trace("Marking class " + clazz + " as used.");
/*     */       }
/* 263 */       ClassContext.access$002(classContext, true);
/* 264 */       return classContext.contexts;
/*     */     }
/* 266 */     return null;
/*     */   }
/*     */ 
/*     */   public Set<KernelControllerContext> getInstantiatedContexts(Class<?> clazz)
/*     */   {
/* 274 */     lockRead();
/*     */     try
/*     */     {
/* 277 */       Set contexts = getContexts(clazz);
/* 278 */       Object localObject1 = (contexts != null) && (!contexts.isEmpty()) ? Collections.unmodifiableSet(contexts) : null;
/*     */       return localObject1; } finally { unlockRead(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   public Set<KernelControllerContext> getContexts(Class<?> clazz, ControllerState state)
/*     */   {
/* 288 */     lockRead();
/*     */     try
/*     */     {
/* 291 */       Set contexts = getContexts(clazz);
/* 292 */       if ((contexts != null) && (!contexts.isEmpty()))
/*     */       {
/* 294 */         kccs = new HashSet();
/* 295 */         List states = getStates();
/* 296 */         int stateIndex = states.indexOf(state);
/* 297 */         for (KernelControllerContext context : contexts)
/*     */         {
/* 299 */           int contextStateIndex = states.indexOf(context.getState());
/* 300 */           if (contextStateIndex >= stateIndex)
/* 301 */             kccs.add(context);
/*     */         }
/* 303 */         ??? = Collections.unmodifiableSet(kccs);
/*     */         return ???;
/*     */       }
/* 306 */       Set kccs = null;
/*     */       return kccs; } finally { unlockRead(); } throw localObject;
/*     */   }
/*     */ 
/*     */   public void addInstantiatedContext(KernelControllerContext context)
/*     */   {
/* 316 */     prepareToTraverse(context, true);
/*     */   }
/*     */ 
/*     */   public void removeInstantiatedContext(KernelControllerContext context)
/*     */   {
/* 321 */     prepareToTraverse(context, false);
/*     */   }
/*     */ 
/*     */   protected void prepareToTraverse(KernelControllerContext context, boolean addition)
/*     */   {
/* 326 */     lockWrite();
/*     */     try
/*     */     {
/* 329 */       Object target = context.getTarget();
/* 330 */       if (target != null)
/*     */       {
/* 332 */         traverseBean(context, target.getClass(), addition, this.log.isTraceEnabled());
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 337 */       unlockWrite();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void traverseBean(KernelControllerContext context, Class<?> clazz, boolean addition, boolean trace)
/*     */   {
/* 352 */     if ((clazz == null) || (clazz == Object.class))
/*     */     {
/* 354 */       return;
/*     */     }
/* 356 */     ClassContext classContext = (ClassContext)this.contextsByClass.get(clazz);
/* 357 */     if (addition)
/*     */     {
/* 359 */       if (classContext == null)
/*     */       {
/* 361 */         classContext = new ClassContext(null);
/* 362 */         ClassContext.access$102(classContext, new HashSet());
/* 363 */         this.contextsByClass.put(clazz, classContext);
/*     */       }
/* 365 */       else if (classContext.used)
/*     */       {
/* 367 */         this.log.warn("Additional matching bean - contextual injection already used for class: " + clazz);
/*     */       }
/* 369 */       if (trace)
/*     */       {
/* 371 */         this.log.trace("Mapping contex " + context + " to class: " + clazz);
/*     */       }
/* 373 */       classContext.contexts.add(context);
/*     */     }
/* 377 */     else if (classContext != null)
/*     */     {
/* 379 */       if (trace)
/*     */       {
/* 381 */         this.log.trace("Removing contex " + context + " to class: " + clazz);
/*     */       }
/* 383 */       classContext.contexts.remove(context);
/*     */     }
/*     */ 
/* 387 */     traverseBean(context, clazz.getSuperclass(), addition, trace);
/* 388 */     Class[] interfaces = clazz.getInterfaces();
/*     */ 
/* 390 */     for (Class intface : interfaces)
/*     */     {
/* 392 */       traverseBean(context, intface, addition, trace);
/*     */     }
/*     */   }
/*     */ 
/*     */   public KernelControllerContext getContextByClass(Class<?> clazz)
/*     */   {
/* 410 */     Set contexts = getInstantiatedContexts(clazz);
/* 411 */     int numberOfMatchingBeans = 0;
/* 412 */     if (contexts != null)
/*     */     {
/* 414 */       numberOfMatchingBeans = contexts.size();
/*     */     }
/*     */ 
/* 417 */     if (this.log.isTraceEnabled())
/*     */     {
/* 419 */       this.log.trace("Checking for contextual injection, current matches: " + numberOfMatchingBeans + " - " + clazz);
/*     */     }
/*     */ 
/* 422 */     if (numberOfMatchingBeans != 1)
/*     */     {
/* 424 */       if (numberOfMatchingBeans > 1)
/*     */       {
/* 426 */         this.log.warn("Multiple beans match class type: " + clazz);
/*     */       }
/* 428 */       return null;
/*     */     }
/* 430 */     return (KernelControllerContext)contexts.iterator().next();
/*     */   }
/*     */ 
/*     */   private class ClassContext
/*     */   {
/*     */     private boolean used;
/*     */     private Set<KernelControllerContext> contexts;
/*     */ 
/*     */     private ClassContext()
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.AbstractKernelController
 * JD-Core Version:    0.6.0
 */