/*    */ package org.jboss.kernel.plugins.dependency;
/*    */ 
/*    */ import org.jboss.kernel.spi.dependency.ConfigureKernelControllerContextAware;
/*    */ import org.jboss.kernel.spi.dependency.CreateKernelControllerContextAware;
/*    */ import org.jboss.kernel.spi.dependency.DescribeKernelControllerContextAware;
/*    */ import org.jboss.kernel.spi.dependency.InstallKernelControllerContextAware;
/*    */ import org.jboss.kernel.spi.dependency.InstantiateKernelControllerContextAware;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
/*    */ import org.jboss.kernel.spi.dependency.StartKernelControllerContextAware;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public abstract class AbstractConfigureAction extends KernelControllerContextAction
/*    */ {
/*    */   protected Class<? extends KernelControllerContextAware> getActionAwareInterface()
/*    */   {
/* 42 */     return ConfigureKernelControllerContextAware.class;
/*    */   }
/*    */ 
/*    */   protected void installKernelControllerContextAware(KernelControllerContext context)
/*    */     throws Throwable
/*    */   {
/* 56 */     Object target = context.getTarget();
/* 57 */     if ((target != null) && (isExactlyKernelControllerContextAware(target)))
/*    */     {
/* 59 */       ((KernelControllerContextAware)target).setKernelControllerContext(context);
/*    */     }
/*    */   }
/*    */ 
/*    */   protected void uninstallKernelControllerContextAware(KernelControllerContext context)
/*    */   {
/* 70 */     Object target = context.getTarget();
/* 71 */     if ((target != null) && (isExactlyKernelControllerContextAware(target)))
/*    */     {
/*    */       try
/*    */       {
/* 75 */         ((KernelControllerContextAware)target).unsetKernelControllerContext(context);
/*    */       }
/*    */       catch (Throwable t)
/*    */       {
/* 79 */         this.log.debug("Ignored error unsetting context ", t);
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   protected boolean isExactlyKernelControllerContextAware(Object o)
/*    */   {
/* 91 */     Class clazz = o.getClass();
/* 92 */     return (KernelControllerContextAware.class.isAssignableFrom(clazz)) && (!ConfigureKernelControllerContextAware.class.isAssignableFrom(clazz)) && (!CreateKernelControllerContextAware.class.isAssignableFrom(clazz)) && (!DescribeKernelControllerContextAware.class.isAssignableFrom(clazz)) && (!InstallKernelControllerContextAware.class.isAssignableFrom(clazz)) && (!InstantiateKernelControllerContextAware.class.isAssignableFrom(clazz)) && (!StartKernelControllerContextAware.class.isAssignableFrom(clazz));
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.AbstractConfigureAction
 * JD-Core Version:    0.6.0
 */