/*     */ package org.jboss.kernel.plugins.config.property;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import java.util.Properties;
/*     */ import java.util.TreeSet;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.config.plugins.property.PropertyConfiguration;
/*     */ import org.jboss.kernel.plugins.bootstrap.basic.KernelConstants;
/*     */ import org.jboss.kernel.plugins.config.AbstractKernelConfig;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.bootstrap.KernelInitializer;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.event.KernelEventManager;
/*     */ import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
/*     */ import org.jboss.kernel.spi.registry.KernelBus;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistry;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class PropertyKernelConfig extends AbstractKernelConfig
/*     */ {
/*     */   public PropertyKernelConfig(Properties properties)
/*     */   {
/*  58 */     super(new PropertyConfiguration(properties));
/*  59 */     initializeProperties();
/*     */   }
/*     */ 
/*     */   protected Properties getProperties()
/*     */   {
/*  64 */     PropertyConfiguration config = (PropertyConfiguration)this.configuration;
/*  65 */     return config.getProperties();
/*     */   }
/*     */ 
/*     */   protected void initializeProperties()
/*     */   {
/*  70 */     Properties properties = getProperties();
/*     */     Iterator i;
/*  72 */     if ((!properties.isEmpty()) && (this.log.isTraceEnabled()))
/*     */     {
/*  74 */       this.log.trace("Dumping properties");
/*  75 */       TreeSet names = new TreeSet(properties.keySet());
/*  76 */       for (i = names.iterator(); i.hasNext(); )
/*     */       {
/*  78 */         String name = (String)i.next();
/*  79 */         this.log.trace(name + "=" + properties.get(name));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public KernelBus createKernelBus() throws Throwable
/*     */   {
/*  86 */     return (KernelBus)getImplementation(KernelConstants.KERNEL_BUS_PROPERTY, "org.jboss.kernel.plugins.registry.basic.BasicKernelBus");
/*     */   }
/*     */ 
/*     */   public KernelConfigurator createKernelConfigurator()
/*     */     throws Throwable
/*     */   {
/*  94 */     return (KernelConfigurator)getImplementation(KernelConstants.KERNEL_CONFIGURATOR_PROPERTY, "org.jboss.kernel.plugins.config.AbstractKernelConfigurator");
/*     */   }
/*     */ 
/*     */   public KernelController createKernelController()
/*     */     throws Throwable
/*     */   {
/* 102 */     return (KernelController)getImplementation(KernelConstants.KERNEL_CONTROLLER_PROPERTY, "org.jboss.kernel.plugins.dependency.AbstractKernelController");
/*     */   }
/*     */ 
/*     */   public KernelEventManager createKernelEventManager()
/*     */     throws Throwable
/*     */   {
/* 110 */     return (KernelEventManager)getImplementation(KernelConstants.KERNEL_EVENT_MANAGER_PROPERTY, "org.jboss.kernel.plugins.event.AbstractEventManager");
/*     */   }
/*     */ 
/*     */   public KernelInitializer createKernelInitializer()
/*     */     throws Throwable
/*     */   {
/* 118 */     return (KernelInitializer)getImplementation(KernelConstants.KERNEL_INITIALIZER_PROPERTY, "org.jboss.kernel.plugins.bootstrap.basic.BasicKernelInitializer");
/*     */   }
/*     */ 
/*     */   public KernelRegistry createKernelRegistry()
/*     */     throws Throwable
/*     */   {
/* 126 */     return (KernelRegistry)getImplementation(KernelConstants.KERNEL_REGISTRY_PROPERTY, "org.jboss.kernel.plugins.registry.basic.BasicKernelRegistry");
/*     */   }
/*     */ 
/*     */   public KernelMetaDataRepository createKernelMetaDataRepository()
/*     */     throws Throwable
/*     */   {
/* 134 */     return (KernelMetaDataRepository)getImplementation(KernelConstants.KERNEL_METADATA_REPOSITORY_PROPERTY, "org.jboss.kernel.plugins.metadata.basic.BasicKernelMetaDataRepository");
/*     */   }
/*     */ 
/*     */   protected Object getImplementation(String type, String defaultType)
/*     */     throws Throwable
/*     */   {
/* 150 */     Properties properties = getProperties();
/*     */ 
/* 152 */     String className = properties.getProperty(type, defaultType);
/* 153 */     if (this.log.isTraceEnabled()) {
/* 154 */       this.log.trace(type + " using implementation " + className);
/*     */     }
/* 156 */     ClassLoader cl = Configurator.getClassLoader((BeanMetaData)null);
/* 157 */     BeanInfo info = getBeanInfo(className, cl);
/* 158 */     BeanMetaData metaData = getBeanMetaData(info, className);
/* 159 */     return Configurator.instantiateAndConfigure(this, info, metaData);
/*     */   }
/*     */ 
/*     */   protected BeanMetaData getBeanMetaData(BeanInfo info, String className)
/*     */     throws Exception
/*     */   {
/* 172 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.config.property.PropertyKernelConfig
 * JD-Core Version:    0.6.0
 */