/*     */ package org.jboss.kernel.plugins.config;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
/*     */ import org.jboss.beans.metadata.spi.ConstructorMetaData;
/*     */ import org.jboss.beans.metadata.spi.ParameterMetaData;
/*     */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.joinpoint.plugins.Config;
/*     */ import org.jboss.joinpoint.spi.ConstructorJoinpoint;
/*     */ import org.jboss.joinpoint.spi.Joinpoint;
/*     */ import org.jboss.joinpoint.spi.JoinpointException;
/*     */ import org.jboss.joinpoint.spi.JoinpointFactory;
/*     */ import org.jboss.joinpoint.spi.MethodJoinpoint;
/*     */ import org.jboss.joinpoint.spi.TargettedJoinpoint;
/*     */ import org.jboss.kernel.spi.config.KernelConfig;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.ConstructorInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ import org.jboss.reflect.spi.TypeInfoFactory;
/*     */ 
/*     */ public class Configurator extends Config
/*     */ {
/*     */   public static Object instantiateAndConfigure(KernelConfig config, BeanInfo info, BeanMetaData metaData)
/*     */     throws Throwable
/*     */   {
/*  67 */     Object result = instantiate(config, info, metaData);
/*  68 */     if (metaData != null)
/*  69 */       configure(result, info, metaData);
/*  70 */     return result;
/*     */   }
/*     */ 
/*     */   public static Object instantiate(KernelConfig config, BeanInfo info, BeanMetaData metaData)
/*     */     throws Throwable
/*     */   {
/*  84 */     boolean trace = log.isTraceEnabled();
/*  85 */     if (trace) {
/*  86 */       log.trace("Instantiating info=" + info + " metaData=" + metaData);
/*     */     }
/*  88 */     ConstructorMetaData constructor = null;
/*  89 */     if (metaData != null)
/*  90 */       constructor = metaData.getConstructor();
/*  91 */     Joinpoint joinPoint = getConstructorJoinPoint(config, info, constructor, metaData);
/*  92 */     return joinPoint.dispatch();
/*     */   }
/*     */ 
/*     */   public static Joinpoint getConstructorJoinPoint(KernelConfig config, BeanInfo info, ConstructorMetaData metaData, BeanMetaData beanMetaData)
/*     */     throws Throwable
/*     */   {
/* 108 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 110 */     if (trace) {
/* 111 */       log.trace("Get constructor joinpoint info=" + info + " constructor=" + metaData);
/*     */     }
/* 113 */     if (config == null) {
/* 114 */       throw new IllegalArgumentException("Null config");
/*     */     }
/* 116 */     if (metaData != null)
/*     */     {
/* 118 */       ClassLoader cl = getClassLoader(beanMetaData);
/*     */ 
/* 120 */       ValueMetaData vmd = metaData.getValue();
/* 121 */       if (vmd != null)
/*     */       {
/* 123 */         TypeInfo typeInfo = null;
/* 124 */         if (info != null)
/* 125 */           typeInfo = info.getClassInfo();
/* 126 */         return new ValueJoinpoint(vmd, typeInfo, cl);
/*     */       }
/*     */ 
/* 129 */       vmd = metaData.getFactory();
/* 130 */       if (vmd != null)
/*     */       {
/* 133 */         Object factory = vmd.getValue(null, cl);
/*     */ 
/* 136 */         List parameters = metaData.getParameters();
/*     */ 
/* 139 */         BeanInfo factoryInfo = config.getBeanInfo(factory.getClass());
/*     */ 
/* 142 */         MethodJoinpoint joinPoint = findMethod(trace, factoryInfo, cl, metaData.getFactoryMethod(), parameters, false, true);
/* 143 */         joinPoint.setTarget(factory);
/* 144 */         MethodInfo minfo = joinPoint.getMethodInfo();
/*     */ 
/* 147 */         if (minfo != null)
/*     */         {
/* 149 */           TypeInfo[] pinfos = minfo.getParameterTypes();
/* 150 */           Object[] params = getParameters(trace, cl, pinfos, parameters);
/* 151 */           joinPoint.setArguments(params);
/*     */         }
/* 153 */         return joinPoint;
/*     */       }
/*     */ 
/* 156 */       String factoryClassName = metaData.getFactoryClass();
/* 157 */       if (factoryClassName != null)
/*     */       {
/* 160 */         List parameters = metaData.getParameters();
/*     */ 
/* 162 */         BeanInfo factoryInfo = config.getBeanInfo(factoryClassName, cl);
/*     */ 
/* 165 */         MethodJoinpoint joinPoint = findMethod(trace, factoryInfo, cl, metaData.getFactoryMethod(), parameters, true, true);
/* 166 */         MethodInfo minfo = joinPoint.getMethodInfo();
/*     */ 
/* 169 */         if (minfo != null)
/*     */         {
/* 171 */           TypeInfo[] pinfos = minfo.getParameterTypes();
/* 172 */           Object[] params = getParameters(trace, cl, pinfos, parameters);
/* 173 */           joinPoint.setArguments(params);
/*     */         }
/* 175 */         return joinPoint;
/*     */       }
/*     */ 
/* 179 */       ConstructorJoinpoint joinPoint = findConstructor(trace, info, metaData);
/* 180 */       ConstructorInfo cinfo = joinPoint.getConstructorInfo();
/*     */ 
/* 183 */       if (cinfo != null)
/*     */       {
/* 185 */         TypeInfo[] pinfos = cinfo.getParameterTypes();
/* 186 */         Object[] params = getParameters(trace, cl, pinfos, metaData.getParameters());
/* 187 */         joinPoint.setArguments(params);
/*     */       }
/* 189 */       return joinPoint;
/*     */     }
/*     */ 
/* 193 */     return findConstructor(trace, info, metaData);
/*     */   }
/*     */ 
/*     */   public static ConstructorJoinpoint findConstructor(boolean trace, BeanInfo info, BeanMetaData metaData)
/*     */     throws Exception
/*     */   {
/* 207 */     return findConstructor(trace, info, metaData.getConstructor());
/*     */   }
/*     */ 
/*     */   public static ConstructorJoinpoint findConstructor(boolean trace, BeanInfo info, ConstructorMetaData metaData)
/*     */     throws Exception
/*     */   {
/* 221 */     ConstructorInfo cinfo = resolveConstructor(trace, info, metaData);
/* 222 */     JoinpointFactory jpf = info.getJoinpointFactory();
/* 223 */     return jpf.getConstructorJoinpoint(cinfo);
/*     */   }
/*     */ 
/*     */   public static ConstructorInfo resolveConstructor(boolean trace, BeanInfo info, ConstructorMetaData metaData)
/*     */   {
/* 236 */     if (info == null) {
/* 237 */       throw new IllegalArgumentException("Null bean info");
/*     */     }
/* 239 */     List params = Collections.EMPTY_LIST;
/* 240 */     if ((metaData != null) && (metaData.getParameters() != null))
/* 241 */       params = metaData.getParameters();
/* 242 */     String[] paramTypes = new String[params.size()];
/*     */     int x;
/*     */     Iterator i;
/* 243 */     if (!params.isEmpty())
/*     */     {
/* 245 */       x = 0;
/* 246 */       for (i = params.iterator(); i.hasNext(); )
/*     */       {
/* 248 */         ParameterMetaData pdata = (ParameterMetaData)i.next();
/* 249 */         paramTypes[(x++)] = pdata.getType();
/*     */       }
/*     */     }
/* 252 */     return findConstructorInfo(info.getClassInfo(), paramTypes);
/*     */   }
/*     */ 
/*     */   public static void configure(Object object, BeanInfo info, BeanMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 265 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 267 */     if (object == null)
/* 268 */       throw new IllegalArgumentException("Null object");
/* 269 */     if (info == null)
/* 270 */       throw new IllegalArgumentException("Null bean info");
/* 271 */     if (metaData == null) {
/* 272 */       throw new IllegalArgumentException("Null bean metadata");
/*     */     }
/* 274 */     Set properties = metaData.getProperties();
/*     */     ClassLoader cl;
/*     */     Iterator i;
/* 275 */     if ((properties != null) && (!properties.isEmpty()))
/*     */     {
/* 277 */       cl = getClassLoader(metaData);
/*     */ 
/* 279 */       for (i = metaData.getProperties().iterator(); i.hasNext(); )
/*     */       {
/* 281 */         PropertyMetaData property = (PropertyMetaData)i.next();
/* 282 */         configure(trace, object, info, cl, property);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void configure(Object object, BeanInfo info, ClassLoader cl, PropertyMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 298 */     boolean trace = log.isTraceEnabled();
/* 299 */     configure(trace, object, info, cl, metaData);
/*     */   }
/*     */ 
/*     */   public static void configure(boolean trace, Object object, BeanInfo info, ClassLoader cl, PropertyMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 314 */     PropertyInfo ainfo = resolveProperty(trace, info, cl, metaData.getName(), metaData.getType());
/* 315 */     configure(trace, object, ainfo, cl, metaData);
/*     */   }
/*     */ 
/*     */   public static void configure(Object object, PropertyInfo info, ClassLoader cl, PropertyMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 329 */     boolean trace = log.isTraceEnabled();
/* 330 */     configure(trace, object, info, cl, metaData);
/*     */   }
/*     */ 
/*     */   public static void configure(boolean trace, Object object, PropertyInfo info, ClassLoader cl, PropertyMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 345 */     if (trace) {
/* 346 */       log.trace("Configuring info=" + info + " metaData=" + metaData);
/*     */     }
/* 348 */     TargettedJoinpoint joinPoint = getPropertySetterJoinPoint(trace, info, cl, metaData.getValue());
/* 349 */     joinPoint.setTarget(object);
/*     */ 
/* 351 */     if (trace) {
/* 352 */       log.trace("Setting property " + joinPoint);
/*     */     }
/* 354 */     joinPoint.dispatch();
/*     */   }
/*     */ 
/*     */   public static TargettedJoinpoint getPropertyGetterJoinPoint(BeanInfo info, String property)
/*     */     throws Throwable
/*     */   {
/* 367 */     boolean trace = log.isTraceEnabled();
/* 368 */     PropertyInfo ainfo = resolveProperty(trace, info, property);
/* 369 */     return getPropertyGetterJoinPoint(trace, ainfo);
/*     */   }
/*     */ 
/*     */   public static TargettedJoinpoint getPropertyGetterJoinPoint(boolean trace, PropertyInfo info)
/*     */     throws Throwable
/*     */   {
/* 382 */     if (trace) {
/* 383 */       log.trace("Get property setter join point info=" + info);
/*     */     }
/* 385 */     if (info == null) {
/* 386 */       throw new IllegalArgumentException("Null property info");
/*     */     }
/* 388 */     JoinpointFactory jpf = info.getBeanInfo().getJoinpointFactory();
/* 389 */     MethodInfo minfo = info.getGetter();
/* 390 */     if (minfo == null)
/* 391 */       throw new IllegalArgumentException("Property is write only: " + info);
/* 392 */     return getMethodJoinpoint(null, jpf, minfo.getName(), null, null);
/*     */   }
/*     */ 
/*     */   public static Set<TargettedJoinpoint> getPropertySetterJoinPoints(BeanInfo info, BeanMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 405 */     boolean trace = log.isTraceEnabled();
/*     */ 
/* 407 */     if (info == null)
/* 408 */       throw new IllegalArgumentException("Null bean info");
/* 409 */     if (metaData == null) {
/* 410 */       throw new IllegalArgumentException("Null bean metadata");
/*     */     }
/* 412 */     Set result = new HashSet();
/* 413 */     Set propertys = metaData.getProperties();
/*     */     ClassLoader cl;
/*     */     Iterator i;
/* 414 */     if ((propertys != null) && (!propertys.isEmpty()))
/*     */     {
/* 416 */       cl = getClassLoader(metaData);
/*     */ 
/* 418 */       for (i = metaData.getProperties().iterator(); i.hasNext(); )
/*     */       {
/* 420 */         PropertyMetaData property = (PropertyMetaData)i.next();
/* 421 */         TargettedJoinpoint joinPoint = getPropertySetterJoinPoint(trace, info, cl, property);
/* 422 */         result.add(joinPoint);
/*     */       }
/*     */     }
/*     */ 
/* 426 */     return result;
/*     */   }
/*     */ 
/*     */   public static TargettedJoinpoint getPropertySetterJoinPoint(BeanInfo info, ClassLoader cl, PropertyMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 440 */     boolean trace = log.isTraceEnabled();
/* 441 */     return getPropertySetterJoinPoint(trace, info, cl, metaData);
/*     */   }
/*     */ 
/*     */   public static TargettedJoinpoint getPropertySetterJoinPoint(boolean trace, BeanInfo info, ClassLoader cl, PropertyMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 456 */     PropertyInfo ainfo = resolveProperty(trace, info, cl, metaData.getName(), metaData.getType());
/* 457 */     return getPropertySetterJoinPoint(trace, ainfo, cl, metaData.getValue());
/*     */   }
/*     */ 
/*     */   public static TargettedJoinpoint getPropertySetterJoinPoint(PropertyInfo info, ClassLoader cl, PropertyMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 471 */     boolean trace = log.isTraceEnabled();
/* 472 */     return getPropertySetterJoinPoint(trace, info, cl, metaData.getValue());
/*     */   }
/*     */ 
/*     */   public static TargettedJoinpoint getPropertySetterJoinPoint(BeanInfo info, String property, ClassLoader cl, ValueMetaData vmd)
/*     */     throws Throwable
/*     */   {
/* 487 */     boolean trace = log.isTraceEnabled();
/* 488 */     PropertyInfo ainfo = resolveProperty(trace, info, property);
/* 489 */     return getPropertySetterJoinPoint(trace, ainfo, cl, vmd);
/*     */   }
/*     */ 
/*     */   public static TargettedJoinpoint getPropertySetterJoinPoint(boolean trace, PropertyInfo info, ClassLoader cl, ValueMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 504 */     if (trace) {
/* 505 */       log.trace("Get property setter join point info=" + info + " metaData=" + metaData);
/*     */     }
/* 507 */     if (info == null)
/* 508 */       throw new IllegalArgumentException("Null property info");
/* 509 */     if (metaData == null) {
/* 510 */       throw new IllegalArgumentException("Null value metadata");
/*     */     }
/* 512 */     TypeInfo type = info.getType();
/* 513 */     Object value = metaData.getValue(type, cl);
/* 514 */     JoinpointFactory jpf = info.getBeanInfo().getJoinpointFactory();
/* 515 */     MethodInfo minfo = info.getSetter();
/* 516 */     if (minfo == null)
/* 517 */       throw new IllegalArgumentException("No setter configured for property: " + info);
/* 518 */     String[] parameterTypes = getParameterTypes(trace, minfo.getParameterTypes());
/* 519 */     return getMethodJoinpoint(null, jpf, minfo.getName(), parameterTypes, new Object[] { value });
/*     */   }
/*     */ 
/*     */   public static void unconfigure(Object object, BeanInfo info, BeanMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 532 */     if (object == null)
/* 533 */       throw new IllegalArgumentException("Null object");
/* 534 */     if (info == null)
/* 535 */       throw new IllegalArgumentException("Null bean info");
/* 536 */     if (metaData == null) {
/* 537 */       throw new IllegalArgumentException("Null bean metadata");
/*     */     }
/* 539 */     ClassLoader cl = getClassLoader(metaData);
/* 540 */     Set propertys = metaData.getProperties();
/*     */     Iterator i;
/* 541 */     if ((propertys != null) && (!propertys.isEmpty()))
/*     */     {
/* 543 */       for (i = metaData.getProperties().iterator(); i.hasNext(); )
/*     */       {
/* 545 */         PropertyMetaData property = (PropertyMetaData)i.next();
/* 546 */         unconfigure(object, cl, info, property);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void unconfigure(Object object, ClassLoader cl, BeanInfo info, PropertyMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 562 */     boolean trace = log.isTraceEnabled();
/* 563 */     PropertyInfo ainfo = resolveProperty(trace, info, cl, metaData.getName(), metaData.getType());
/* 564 */     unconfigure(trace, object, ainfo, metaData);
/*     */   }
/*     */ 
/*     */   public static void unconfigure(boolean trace, Object object, PropertyInfo info, PropertyMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 578 */     if (trace) {
/* 579 */       log.trace("Unconfiguring info=" + info + " metaData=" + metaData);
/*     */     }
/* 581 */     TargettedJoinpoint joinPoint = getPropertyNullerJoinPoint(info, metaData);
/* 582 */     joinPoint.setTarget(object);
/*     */ 
/* 584 */     if (trace) {
/* 585 */       log.trace("Unsetting property " + joinPoint);
/*     */     }
/* 587 */     joinPoint.dispatch();
/*     */   }
/*     */ 
/*     */   public static Set<TargettedJoinpoint> getPropertyNullerJoinPoints(BeanInfo info, BeanMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 600 */     if (info == null)
/* 601 */       throw new IllegalArgumentException("Null bean info");
/* 602 */     if (metaData == null) {
/* 603 */       throw new IllegalArgumentException("Null bean metadata");
/*     */     }
/* 605 */     Set result = new HashSet();
/* 606 */     Set propertys = metaData.getProperties();
/*     */     Iterator i;
/* 607 */     if ((propertys != null) && (!propertys.isEmpty()))
/*     */     {
/* 609 */       for (i = metaData.getProperties().iterator(); i.hasNext(); )
/*     */       {
/* 611 */         PropertyMetaData property = (PropertyMetaData)i.next();
/* 612 */         TargettedJoinpoint joinPoint = getPropertyNullerJoinPoint(info, property);
/* 613 */         result.add(joinPoint);
/*     */       }
/*     */     }
/* 616 */     return result;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public static TargettedJoinpoint getPropertyNullerJoinPoint(BeanInfo info, PropertyMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 630 */     return getPropertyNullerJoinPoint(null, info, metaData);
/*     */   }
/*     */ 
/*     */   public static TargettedJoinpoint getPropertyNullerJoinPoint(ClassLoader cl, BeanInfo info, PropertyMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 644 */     boolean trace = log.isTraceEnabled();
/* 645 */     PropertyInfo ainfo = resolveProperty(trace, info, cl, metaData.getName(), metaData.getType());
/* 646 */     return getPropertyNullerJoinPoint(ainfo, metaData);
/*     */   }
/*     */ 
/*     */   public static TargettedJoinpoint getPropertyNullerJoinPoint(PropertyInfo info, PropertyMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 659 */     boolean trace = log.isTraceEnabled();
/* 660 */     if (trace) {
/* 661 */       log.trace("Get property nuller join point info=" + info + " metaData=" + metaData);
/*     */     }
/* 663 */     if (info == null) {
/* 664 */       throw new IllegalArgumentException("Null property info");
/*     */     }
/* 666 */     JoinpointFactory jpf = info.getBeanInfo().getJoinpointFactory();
/* 667 */     MethodInfo minfo = info.getSetter();
/* 668 */     if (minfo == null)
/* 669 */       throw new IllegalArgumentException("Property is read only: " + info);
/* 670 */     String[] parameterTypes = getParameterTypes(trace, minfo.getParameterTypes());
/* 671 */     return getMethodJoinpoint(null, jpf, minfo.getName(), parameterTypes, new Object[] { null });
/*     */   }
/*     */ 
/*     */   public static PropertyInfo resolveProperty(boolean trace, BeanInfo info, String name)
/*     */     throws Throwable
/*     */   {
/* 685 */     return resolveProperty(trace, info, null, name, null);
/*     */   }
/*     */ 
/*     */   public static PropertyInfo resolveProperty(boolean trace, BeanInfo info, ClassLoader cl, String name, String type)
/*     */     throws Throwable
/*     */   {
/* 701 */     if (info == null)
/* 702 */       throw new IllegalArgumentException("Null bean info");
/* 703 */     if (name == null) {
/* 704 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 706 */     if (trace) {
/* 707 */       log.trace("Resolving property on bean info=" + info + " name=" + name);
/*     */     }
/*     */ 
/* 711 */     if (cl == null) {
/* 712 */       cl = info.getClassInfo().getType().getClassLoader();
/*     */     }
/* 714 */     Set properties = info.getProperties();
/*     */     TypeInfoFactory tif;
/* 715 */     if ((properties != null) && (properties.size() > 0))
/*     */     {
/* 717 */       ClassInfo classInfo = info.getClassInfo();
/* 718 */       tif = classInfo.getTypeInfoFactory();
/* 719 */       if (tif == null) {
/* 720 */         throw new IllegalArgumentException("TypeInfoFactory is null: " + classInfo);
/*     */       }
/* 722 */       for (PropertyInfo ainfo : properties)
/*     */       {
/* 724 */         if (name.equals(ainfo.getName()))
/*     */         {
/* 726 */           String[] typeNames = { type };
/* 727 */           TypeInfo[] typeInfos = { ainfo.getType() };
/* 728 */           if ((equals(typeNames, typeInfos)) || (isAssignable(tif, cl, typeNames, typeInfos)))
/*     */           {
/* 730 */             return ainfo;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 736 */     throw new JoinpointException("Property " + name + " not found for " + info);
/*     */   }
/*     */ 
/*     */   public static MethodJoinpoint findMethod(BeanInfo info, ClassLoader cl, String name, List parameters, boolean isStatic, boolean isPublic)
/*     */     throws Throwable
/*     */   {
/* 753 */     boolean trace = log.isTraceEnabled();
/* 754 */     return findMethod(trace, info, cl, name, parameters, isStatic, isPublic);
/*     */   }
/*     */ 
/*     */   public static MethodJoinpoint findMethod(boolean trace, BeanInfo info, ClassLoader cl, String name, List parameters, boolean isStatic, boolean isPublic)
/*     */     throws Throwable
/*     */   {
/* 772 */     if (info == null)
/* 773 */       throw new IllegalArgumentException("Null bean info");
/* 774 */     if (name == null) {
/* 775 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 777 */     String[] paramTypes = getParameterTypes(trace, parameters);
/* 778 */     MethodInfo minfo = findMethodInfo(info.getClassInfo(), name, paramTypes, isStatic, isPublic);
/* 779 */     JoinpointFactory jpf = info.getJoinpointFactory();
/* 780 */     MethodJoinpoint joinPoint = jpf.getMethodJoinpoint(minfo);
/*     */ 
/* 783 */     if (minfo != null)
/*     */     {
/* 785 */       TypeInfo[] pinfos = minfo.getParameterTypes();
/* 786 */       Object[] params = getParameters(trace, cl, pinfos, parameters);
/* 787 */       joinPoint.setArguments(params);
/*     */     }
/*     */ 
/* 790 */     return joinPoint;
/*     */   }
/*     */ 
/*     */   public static String[] getParameterTypes(boolean trace, List parameters)
/*     */     throws Throwable
/*     */   {
/* 803 */     if (parameters == null) {
/* 804 */       return null;
/*     */     }
/* 806 */     String[] paramTypes = new String[parameters.size()];
/* 807 */     int x = 0;
/* 808 */     for (Iterator i = parameters.iterator(); i.hasNext(); )
/*     */     {
/* 810 */       ParameterMetaData pmd = (ParameterMetaData)i.next();
/* 811 */       paramTypes[(x++)] = pmd.getType();
/*     */     }
/* 813 */     return paramTypes;
/*     */   }
/*     */ 
/*     */   public static String[] getParameterTypes(boolean trace, TypeInfo[] parameters)
/*     */     throws Throwable
/*     */   {
/* 826 */     if (parameters == null) {
/* 827 */       return null;
/*     */     }
/* 829 */     String[] paramTypes = new String[parameters.length];
/* 830 */     int x = 0;
/* 831 */     for (int i = 0; i < parameters.length; i++)
/* 832 */       paramTypes[(x++)] = parameters[i].getName();
/* 833 */     return paramTypes;
/*     */   }
/*     */ 
/*     */   public static Object[] getParameters(boolean trace, ClassLoader cl, TypeInfo[] pinfos, List parameters)
/*     */     throws Throwable
/*     */   {
/* 848 */     if (parameters == null) {
/* 849 */       return null;
/*     */     }
/* 851 */     Object[] params = new Object[parameters.size()];
/* 852 */     int x = 0;
/* 853 */     for (Iterator i = parameters.iterator(); i.hasNext(); )
/*     */     {
/* 855 */       ParameterMetaData pdata = (ParameterMetaData)i.next();
/* 856 */       ValueMetaData vmd = pdata.getValue();
/* 857 */       params[x] = vmd.getValue(pinfos[x], cl);
/* 858 */       x++;
/*     */     }
/* 860 */     return params;
/*     */   }
/*     */ 
/*     */   public static ClassLoader getClassLoader(BeanMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 872 */     ClassLoaderMetaData clmd = null;
/* 873 */     if (metaData != null)
/* 874 */       clmd = metaData.getClassLoader();
/* 875 */     return getClassLoader(clmd);
/*     */   }
/*     */ 
/*     */   public static ClassLoader getClassLoader(ClassLoaderMetaData metaData)
/*     */     throws Throwable
/*     */   {
/* 887 */     ClassLoader tcl = Thread.currentThread().getContextClassLoader();
/* 888 */     ClassLoader cl = null;
/* 889 */     if (metaData != null)
/*     */     {
/* 891 */       ValueMetaData clVMD = metaData.getClassLoader();
/* 892 */       if (clVMD != null)
/*     */       {
/* 894 */         Object object = clVMD.getValue(null, tcl);
/* 895 */         if ((object != null) && (!(object instanceof ClassLoader)))
/* 896 */           throw new IllegalArgumentException("Configured object is not a classloader " + metaData);
/* 897 */         cl = (ClassLoader)object;
/*     */       }
/*     */     }
/* 900 */     if (cl == null)
/* 901 */       cl = tcl;
/* 902 */     return cl;
/*     */   }
/*     */ 
/*     */   public static boolean isAssignable(TypeInfoFactory tif, ClassLoader cl, String[] typeNames, TypeInfo[] typeInfos)
/*     */     throws Throwable
/*     */   {
/* 918 */     if (cl == null) {
/* 919 */       return false;
/*     */     }
/* 921 */     if (!simpleCheck(typeNames, typeInfos)) {
/* 922 */       return false;
/*     */     }
/* 924 */     for (int i = 0; i < typeNames.length; i++)
/*     */     {
/* 926 */       if (typeNames[i] == null)
/*     */         continue;
/* 928 */       if (!typeInfos[i].isAssignableFrom(tif.getTypeInfo(typeNames[i], cl)))
/*     */       {
/* 930 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 934 */     return true;
/*     */   }
/*     */ 
/*     */   private static class ValueJoinpoint
/*     */     implements Joinpoint
/*     */   {
/*     */     private ValueMetaData vmd;
/*     */     private TypeInfo info;
/*     */     private ClassLoader cl;
/*     */ 
/*     */     public ValueJoinpoint(ValueMetaData vmd, TypeInfo info, ClassLoader cl)
/*     */     {
/* 960 */       this.vmd = vmd;
/* 961 */       this.info = info;
/* 962 */       this.cl = cl;
/*     */     }
/*     */ 
/*     */     public Object dispatch() throws Throwable
/*     */     {
/* 967 */       return this.vmd.getValue(this.info, this.cl);
/*     */     }
/*     */ 
/*     */     public String toHumanReadableString()
/*     */     {
/* 972 */       return this.vmd.toShortString();
/*     */     }
/*     */ 
/*     */     public Object clone()
/*     */     {
/*     */       try
/*     */       {
/* 979 */         return super.clone();
/*     */       }
/*     */       catch (CloneNotSupportedException e) {
/*     */       }
/* 983 */       throw new Error(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.config.Configurator
 * JD-Core Version:    0.6.0
 */