/*     */ package org.jboss.kernel.plugins.config;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.ConstructorMetaData;
/*     */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.joinpoint.spi.Joinpoint;
/*     */ import org.jboss.joinpoint.spi.MethodJoinpoint;
/*     */ import org.jboss.joinpoint.spi.TargettedJoinpoint;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.AbstractKernelObject;
/*     */ import org.jboss.kernel.spi.config.KernelConfig;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class AbstractKernelConfigurator extends AbstractKernelObject
/*     */   implements KernelConfigurator
/*     */ {
/*     */   protected KernelConfig config;
/*     */ 
/*     */   public AbstractKernelConfigurator()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public BeanInfo getBeanInfo(String className, ClassLoader cl)
/*     */     throws Throwable
/*     */   {
/*  65 */     return this.config.getBeanInfo(className, cl);
/*     */   }
/*     */ 
/*     */   public BeanInfo getBeanInfo(Class clazz) throws Throwable
/*     */   {
/*  70 */     return this.config.getBeanInfo(clazz);
/*     */   }
/*     */ 
/*     */   public BeanInfo getBeanInfo(TypeInfo type) throws Throwable
/*     */   {
/*  75 */     return this.config.getBeanInfo(type);
/*     */   }
/*     */ 
/*     */   public BeanInfo getBeanInfo(BeanMetaData metaData) throws Throwable
/*     */   {
/*  80 */     ClassLoader cl = Configurator.getClassLoader(metaData);
/*  81 */     String className = metaData.getBean();
/*  82 */     if (className == null)
/*  83 */       return null;
/*  84 */     return getBeanInfo(className, cl);
/*     */   }
/*     */ 
/*     */   public ClassInfo getClassInfo(String className, ClassLoader cl) throws Throwable
/*     */   {
/*  89 */     return this.config.getClassInfo(className, cl);
/*     */   }
/*     */ 
/*     */   public ClassInfo getClassInfo(Class clazz) throws Throwable
/*     */   {
/*  94 */     return this.config.getClassInfo(clazz);
/*     */   }
/*     */ 
/*     */   public Joinpoint getConstructorJoinPoint(BeanInfo info) throws Throwable
/*     */   {
/*  99 */     return getConstructorJoinPoint(info, null, null);
/*     */   }
/*     */ 
/*     */   public Joinpoint getConstructorJoinPoint(BeanMetaData metaData) throws Throwable
/*     */   {
/* 104 */     BeanInfo info = getBeanInfo(metaData);
/* 105 */     return getConstructorJoinPoint(info, metaData.getConstructor(), metaData);
/*     */   }
/*     */ 
/*     */   public Joinpoint getConstructorJoinPoint(BeanInfo info, ConstructorMetaData metaData, BeanMetaData beanMetaData) throws Throwable
/*     */   {
/* 110 */     return Configurator.getConstructorJoinPoint(this.config, info, metaData, beanMetaData);
/*     */   }
/*     */ 
/*     */   public TargettedJoinpoint getPropertyGetterJoinPoint(BeanInfo info, String property) throws Throwable
/*     */   {
/* 115 */     return Configurator.getPropertyGetterJoinPoint(info, property);
/*     */   }
/*     */ 
/*     */   public Set<TargettedJoinpoint> getPropertySetterJoinPoints(BeanInfo info, BeanMetaData metaData) throws Throwable
/*     */   {
/* 120 */     return Configurator.getPropertySetterJoinPoints(info, metaData);
/*     */   }
/*     */ 
/*     */   public TargettedJoinpoint getPropertySetterJoinPoint(BeanInfo info, ClassLoader cl, PropertyMetaData metaData) throws Throwable
/*     */   {
/* 125 */     return Configurator.getPropertySetterJoinPoint(info, cl, metaData);
/*     */   }
/*     */ 
/*     */   public TargettedJoinpoint getPropertySetterJoinPoint(PropertyInfo info, ClassLoader cl, PropertyMetaData metaData) throws Throwable
/*     */   {
/* 130 */     return Configurator.getPropertySetterJoinPoint(info, cl, metaData);
/*     */   }
/*     */ 
/*     */   public TargettedJoinpoint getPropertySetterJoinPoint(BeanInfo info, String property, ClassLoader cl, ValueMetaData vmd) throws Throwable
/*     */   {
/* 135 */     return Configurator.getPropertySetterJoinPoint(info, property, cl, vmd);
/*     */   }
/*     */ 
/*     */   public Set<TargettedJoinpoint> getPropertyNullerJoinPoints(BeanInfo info, BeanMetaData metaData) throws Throwable
/*     */   {
/* 140 */     return Configurator.getPropertyNullerJoinPoints(info, metaData);
/*     */   }
/*     */ 
/*     */   public TargettedJoinpoint getPropertyNullerJoinPoint(BeanInfo info, PropertyMetaData metaData) throws Throwable
/*     */   {
/* 145 */     return Configurator.getPropertyNullerJoinPoint(info, metaData);
/*     */   }
/*     */ 
/*     */   public TargettedJoinpoint getPropertyNullerJoinPoint(PropertyInfo info, PropertyMetaData metaData) throws Throwable
/*     */   {
/* 150 */     return Configurator.getPropertyNullerJoinPoint(info, metaData);
/*     */   }
/*     */ 
/*     */   public MethodJoinpoint getMethodJoinPoint(BeanInfo info, ClassLoader cl, String name, List parameters, boolean isStatic, boolean isPublic) throws Throwable
/*     */   {
/* 155 */     return Configurator.findMethod(info, cl, name, parameters, isStatic, isPublic);
/*     */   }
/*     */ 
/*     */   public void setKernel(Kernel kernel) throws Throwable
/*     */   {
/* 160 */     super.setKernel(kernel);
/* 161 */     this.config = kernel.getConfig();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.config.AbstractKernelConfigurator
 * JD-Core Version:    0.6.0
 */