/*     */ package org.jboss.kernel.plugins.bootstrap.standalone;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.util.Enumeration;
/*     */ import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
/*     */ import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class StandaloneBootstrap extends BasicBootstrap
/*     */ {
/*     */   protected BasicXMLDeployer deployer;
/*     */   protected String[] args;
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/*  53 */     StandaloneBootstrap bootstrap = new StandaloneBootstrap(args);
/*  54 */     bootstrap.run();
/*     */   }
/*     */ 
/*     */   public StandaloneBootstrap(String[] args)
/*     */     throws Exception
/*     */   {
/*  66 */     this.args = args;
/*     */   }
/*     */ 
/*     */   public void bootstrap() throws Throwable
/*     */   {
/*  71 */     super.bootstrap();
/*     */ 
/*  73 */     this.deployer = new BasicXMLDeployer(getKernel());
/*     */ 
/*  75 */     Runtime.getRuntime().addShutdownHook(new Shutdown());
/*     */ 
/*  77 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/*  78 */     for (Enumeration e = cl.getResources("jboss-beans.xml"); e.hasMoreElements(); )
/*     */     {
/*  80 */       URL url = (URL)e.nextElement();
/*  81 */       deploy(url);
/*     */     }
/*  83 */     for (Enumeration e = cl.getResources("META-INF/jboss-beans.xml"); e.hasMoreElements(); )
/*     */     {
/*  85 */       URL url = (URL)e.nextElement();
/*  86 */       deploy(url);
/*     */     }
/*     */ 
/*  90 */     this.deployer.validate();
/*     */   }
/*     */ 
/*     */   protected void deploy(URL url)
/*     */     throws Throwable
/*     */   {
/* 101 */     this.deployer.deploy(url);
/*     */   }
/*     */ 
/*     */   protected void undeploy(URL url)
/*     */   {
/*     */     try
/*     */     {
/* 113 */       this.deployer.undeploy(url);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 117 */       this.log.warn("Error during undeployment: " + url, t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class Shutdown extends Thread {
/*     */     protected Shutdown() {
/*     */     }
/*     */ 
/*     */     public void run() {
/* 125 */       StandaloneBootstrap.this.log.info("Shutting down");
/* 126 */       StandaloneBootstrap.this.deployer.shutdown();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.bootstrap.standalone.StandaloneBootstrap
 * JD-Core Version:    0.6.0
 */