/*     */ package org.jboss.kernel.plugins.bootstrap.basic;
/*     */ 
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.bootstrap.AbstractKernelInitializer;
/*     */ import org.jboss.kernel.plugins.registry.BeanKernelRegistryEntry;
/*     */ import org.jboss.kernel.spi.config.KernelConfig;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelController;
/*     */ import org.jboss.kernel.spi.event.KernelEventManager;
/*     */ import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
/*     */ import org.jboss.kernel.spi.registry.KernelBus;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistry;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryEntry;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class BasicKernelInitializer extends AbstractKernelInitializer
/*     */ {
/*     */   public BasicKernelInitializer()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void initKernel(Kernel kernel)
/*     */     throws Throwable
/*     */   {
/*  56 */     KernelMetaDataRepository metaDataRepository = createKernelMetaDataRepository(kernel);
/*  57 */     if (this.trace)
/*  58 */       this.log.trace("Using MetaDataRepository: " + metaDataRepository);
/*  59 */     kernel.setMetaDataRepository(metaDataRepository);
/*     */ 
/*  61 */     KernelRegistry registry = createKernelRegistry(kernel);
/*  62 */     if (this.trace)
/*  63 */       this.log.trace("Using Registry: " + registry);
/*  64 */     registry.setKernel(kernel);
/*  65 */     kernel.setRegistry(registry);
/*     */ 
/*  67 */     KernelEventManager eventManager = createKernelEventManager(kernel);
/*  68 */     if (this.trace)
/*  69 */       this.log.trace("Using EventManager: " + eventManager);
/*  70 */     eventManager.setKernel(kernel);
/*  71 */     kernel.setEventManager(eventManager);
/*     */ 
/*  73 */     KernelConfigurator configurator = createKernelConfigurator(kernel);
/*  74 */     if (this.trace)
/*  75 */       this.log.trace("Using Configurator: " + configurator);
/*  76 */     configurator.setKernel(kernel);
/*  77 */     kernel.setConfigurator(configurator);
/*     */ 
/*  79 */     KernelController controller = createKernelController(kernel);
/*  80 */     if (this.trace)
/*  81 */       this.log.trace("Using Controller: " + controller);
/*  82 */     controller.setKernel(kernel);
/*  83 */     kernel.setController(controller);
/*     */ 
/*  85 */     KernelBus bus = createKernelBus(kernel);
/*  86 */     if (this.trace)
/*  87 */       this.log.trace("Using Bus: " + bus);
/*  88 */     bus.setKernel(kernel);
/*  89 */     kernel.setBus(bus);
/*     */ 
/*  92 */     register(kernel, "jboss.kernel:service=KernelConfig", kernel.getConfig());
/*  93 */     register(kernel, "jboss.kernel:service=KernelInit", this);
/*  94 */     register(kernel, "jboss.kernel:service=Kernel", kernel);
/*  95 */     register(kernel, "jboss.kernel:service=KernelRegistry", registry);
/*  96 */     register(kernel, "jboss.kernel:service=KernelEventManager", eventManager);
/*  97 */     register(kernel, "jboss.kernel:service=KernelBus", bus);
/*  98 */     register(kernel, "jboss.kernel:service=KernelConfigurator", configurator);
/*  99 */     register(kernel, "jboss.kernel:service=KernelController", controller);
/* 100 */     register(kernel, "jboss.kernel:service=MetaDataRepository", metaDataRepository);
/*     */   }
/*     */ 
/*     */   protected KernelBus createKernelBus(Kernel kernel)
/*     */     throws Throwable
/*     */   {
/* 112 */     return kernel.getConfig().createKernelBus();
/*     */   }
/*     */ 
/*     */   protected KernelConfigurator createKernelConfigurator(Kernel kernel)
/*     */     throws Throwable
/*     */   {
/* 124 */     return kernel.getConfig().createKernelConfigurator();
/*     */   }
/*     */ 
/*     */   protected KernelController createKernelController(Kernel kernel)
/*     */     throws Throwable
/*     */   {
/* 136 */     return kernel.getConfig().createKernelController();
/*     */   }
/*     */ 
/*     */   protected KernelEventManager createKernelEventManager(Kernel kernel)
/*     */     throws Throwable
/*     */   {
/* 148 */     return kernel.getConfig().createKernelEventManager();
/*     */   }
/*     */ 
/*     */   protected KernelRegistry createKernelRegistry(Kernel kernel)
/*     */     throws Throwable
/*     */   {
/* 160 */     return kernel.getConfig().createKernelRegistry();
/*     */   }
/*     */ 
/*     */   protected KernelMetaDataRepository createKernelMetaDataRepository(Kernel kernel)
/*     */     throws Throwable
/*     */   {
/* 172 */     return kernel.getConfig().createKernelMetaDataRepository();
/*     */   }
/*     */ 
/*     */   protected void register(Kernel kernel, String name, Object object)
/*     */     throws Throwable
/*     */   {
/* 185 */     register(kernel, getName(name), object);
/*     */   }
/*     */ 
/*     */   protected void register(Kernel kernel, Object name, Object object)
/*     */     throws Throwable
/*     */   {
/* 198 */     KernelRegistryEntry entry = createKernelRegistryEntry(kernel, object);
/* 199 */     KernelRegistry registry = kernel.getRegistry();
/* 200 */     registry.registerEntry(name, entry);
/*     */   }
/*     */ 
/*     */   protected Object getName(String name)
/*     */     throws Throwable
/*     */   {
/* 212 */     return name;
/*     */   }
/*     */ 
/*     */   protected KernelRegistryEntry createKernelRegistryEntry(Kernel kernel, Object object)
/*     */     throws Throwable
/*     */   {
/* 225 */     KernelConfig config = kernel.getConfig();
/* 226 */     BeanInfo info = config.getBeanInfo(object.getClass());
/* 227 */     return new BeanKernelRegistryEntry(object, info);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.bootstrap.basic.BasicKernelInitializer
 * JD-Core Version:    0.6.0
 */