/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import org.jboss.beans.metadata.api.annotations.Parameter;
/*    */ import org.jboss.beans.metadata.api.annotations.ValueFactory;
/*    */ import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractValueFactoryMetaData;
/*    */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ 
/*    */ public class ValueFactoryAnnotationPlugin extends PropertyAnnotationPlugin<ValueFactory>
/*    */ {
/* 42 */   static ValueFactoryAnnotationPlugin INSTANCE = new ValueFactoryAnnotationPlugin();
/*    */ 
/*    */   public ValueFactoryAnnotationPlugin()
/*    */   {
/* 46 */     super(ValueFactory.class);
/*    */   }
/*    */ 
/*    */   public ValueMetaData createValueMetaData(ValueFactory annotation)
/*    */   {
/* 51 */     AbstractValueFactoryMetaData factory = new AbstractValueFactoryMetaData(annotation.bean(), annotation.method());
/* 52 */     if (isAttributePresent(annotation.defaultValue()))
/* 53 */       factory.setDefaultValue(annotation.defaultValue());
/* 54 */     List parameters = new ArrayList();
/* 55 */     if (isAttributePresent(annotation.parameter()))
/* 56 */       parameters.add(new AbstractParameterMetaData(String.class.getName(), annotation.parameter()));
/* 57 */     if (annotation.parameters().length > 0)
/*    */     {
/* 59 */       if (parameters.size() > 0)
/* 60 */         throw new IllegalArgumentException("Cannot set both parameter and parameters!");
/* 61 */       for (Parameter parameter : annotation.parameters())
/*    */       {
/* 63 */         AbstractParameterMetaData apmd = new AbstractParameterMetaData(ValueUtil.createValueMetaData(parameter));
/* 64 */         if (isAttributePresent(parameter.type()))
/* 65 */           apmd.setType(parameter.type());
/* 66 */         parameters.add(apmd);
/*    */       }
/*    */     }
/* 69 */     factory.setParameters(parameters);
/* 70 */     factory.setDependentState(new ControllerState(annotation.dependantState()));
/* 71 */     factory.setWhenRequiredState(new ControllerState(annotation.whenRequiredState()));
/* 72 */     return factory;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.ValueFactoryAnnotationPlugin
 * JD-Core Version:    0.6.0
 */