/*     */ package org.jboss.kernel.plugins.annotations;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.annotation.ElementType;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractLifecycleMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.ParameterInfo;
/*     */ 
/*     */ public abstract class LifecycleParameterAnnotationPlugin<C extends Annotation> extends AbstractParameterAnnotationPlugin<MethodInfo, C, AbstractLifecycleMetaData>
/*     */ {
/*     */   protected LifecycleParameterAnnotationPlugin(Class<C> annotation, Annotation2ValueMetaDataAdapter[] adapters)
/*     */   {
/*  46 */     super(annotation, adapters);
/*     */   }
/*     */ 
/*     */   protected boolean checkAnnotatedInfo(ElementType type)
/*     */   {
/*  51 */     return ElementType.METHOD == type;
/*     */   }
/*     */ 
/*     */   protected abstract boolean isLifecyclePresent(BeanMetaData paramBeanMetaData);
/*     */ 
/*     */   protected AbstractLifecycleMetaData createLifecycleMetaData(String method, C annotation)
/*     */   {
/*  64 */     AbstractLifecycleMetaData lifecycle = new AbstractLifecycleMetaData(method);
/*  65 */     applyLifecycleAnnotation(lifecycle, annotation);
/*  66 */     return lifecycle;
/*     */   }
/*     */ 
/*     */   protected abstract void applyLifecycleAnnotation(AbstractLifecycleMetaData paramAbstractLifecycleMetaData, C paramC);
/*     */ 
/*     */   protected abstract void setLifecycleMetaData(AbstractBeanMetaData paramAbstractBeanMetaData, AbstractLifecycleMetaData paramAbstractLifecycleMetaData);
/*     */ 
/*     */   protected boolean isMetaDataAlreadyPresent(MethodInfo info, C annotation, BeanMetaData beanMetaData)
/*     */   {
/*  87 */     return isLifecyclePresent(beanMetaData);
/*     */   }
/*     */ 
/*     */   protected ParameterInfo[] getParameters(MethodInfo info)
/*     */   {
/*  92 */     return info.getParameters();
/*     */   }
/*     */ 
/*     */   protected List<? extends MetaDataVisitorNode> handleParameterlessInfo(MethodInfo info, C annotation, BeanMetaData beanMetaData)
/*     */   {
/*  97 */     AbstractBeanMetaData abmd = (AbstractBeanMetaData)beanMetaData;
/*  98 */     AbstractLifecycleMetaData lifecycle = createLifecycleMetaData(info.getName(), annotation);
/*  99 */     setLifecycleMetaData(abmd, lifecycle);
/* 100 */     return Collections.singletonList(lifecycle);
/*     */   }
/*     */ 
/*     */   protected AbstractLifecycleMetaData createParametrizedMetaData(MethodInfo info, C annotation)
/*     */   {
/* 105 */     return createLifecycleMetaData(info.getName(), annotation);
/*     */   }
/*     */ 
/*     */   protected void setParameterizedMetaData(AbstractLifecycleMetaData parameterizedMetaData, BeanMetaData beanMetaData)
/*     */   {
/* 110 */     AbstractBeanMetaData abmd = (AbstractBeanMetaData)beanMetaData;
/* 111 */     setLifecycleMetaData(abmd, parameterizedMetaData);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.LifecycleParameterAnnotationPlugin
 * JD-Core Version:    0.6.0
 */