/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ import org.jboss.beans.info.spi.BeanInfo;
/*    */ import org.jboss.beans.metadata.api.annotations.JavaBeanValue;
/*    */ import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
/*    */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*    */ import org.jboss.config.plugins.property.PropertyConfiguration;
/*    */ import org.jboss.config.spi.Configuration;
/*    */ 
/*    */ public class JavaBeanValueAnnotationPlugin extends PropertyAnnotationPlugin<JavaBeanValue>
/*    */ {
/* 41 */   static JavaBeanValueAnnotationPlugin INSTANCE = new JavaBeanValueAnnotationPlugin();
/*    */ 
/* 49 */   private static Configuration configuration = (Configuration)AccessController.doPrivileged(new PrivilegedAction()
/*    */   {
/*    */     public Configuration run()
/*    */     {
/* 53 */       return new PropertyConfiguration();
/*    */     }
/*    */   });
/*    */ 
/*    */   public JavaBeanValueAnnotationPlugin()
/*    */   {
/* 60 */     super(JavaBeanValue.class);
/*    */   }
/*    */ 
/*    */   public ValueMetaData createValueMetaData(JavaBeanValue annotation)
/*    */   {
/* 65 */     String className = annotation.value();
/* 66 */     if (!isAttributePresent(className)) {
/* 67 */       throw new IllegalArgumentException("Javabean class must be set: " + annotation);
/*    */     }
/*    */     try
/*    */     {
/* 71 */       BeanInfo beanInfo = configuration.getBeanInfo(className, null);
/* 72 */       return new AbstractValueMetaData(beanInfo.newInstance());
/*    */     }
/*    */     catch (Throwable t) {
/*    */     }
/* 76 */     throw new IllegalArgumentException("Exception while creating javabean: " + t);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.JavaBeanValueAnnotationPlugin
 * JD-Core Version:    0.6.0
 */